package smart_gs.swingui;

import java.util.List;

import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

import smart_gs.drawing_tool.action.SheetSelectAction;
import smart_gs.logical.Sheet;
import smart_gs.logical.Spread;
import smart_gs.logical.SpreadDirectory;
import smart_gs.logical.SpreadTree;
import smart_gs.swingui.tree.action.AddDirectoryAction;
import smart_gs.swingui.tree.action.AddSheetAction;
import smart_gs.swingui.tree.action.DeleteDirectoryAction;
import smart_gs.swingui.tree.action.DeleteSheetAction;


public class SheetSelectPopupMenu extends JPopupMenu {
	private JMenuItem setSheetNameItem;
	private JMenuItem showSheetItem;
	
	public SheetSelectPopupMenu(SpreadTree tree){
	
		Spread selectedSpread = tree.getSelectedSpread();
		if(selectedSpread != null){
			//kazuhiro kobayashi 10/3
			//10/4 sheet̖Ot悤ɂB
			List<Sheet> sheets = selectedSpread.getSheets();
			JMenu[] sheetName = new JMenu[sheets.size()];
			for(int i = 0; i < sheets.size(); i++){
				this.setSheetNameItem = new JMenuItem("Set Sheet Name");
				this.showSheetItem = new JMenuItem("Show Sheet");
				 sheetName[i] = new JMenu(sheets.get(i).getSheetName());
				 sheetName[i].add(setSheetNameItem);
				 sheetName[i].add(showSheetItem);
				 this.showSheetItem.addActionListener(new SheetSelectAction(sheets.get(i)));
				 this.setSheetNameItem.addActionListener(new SetSheetNameAction(sheets.get(i)));
				 this.add(sheetName[i]);
			}
			JMenuItem deleteItem = new JMenuItem("Delete Sheet");
			deleteItem.addActionListener(new DeleteSheetAction(tree));
			this.add(deleteItem);
		}else{
			SpreadDirectory spreadDirectory = tree.getSelectedSpreadDirectory();
			if(spreadDirectory != null){
				JMenuItem addItem = new JMenuItem("Add Sheet");
				addItem.addActionListener(new AddSheetAction(spreadDirectory.getFile(),tree,spreadDirectory));
				this.add(addItem);
				JMenuItem addDirectory = new JMenuItem("Add Directory");
				addDirectory.addActionListener(new AddDirectoryAction(spreadDirectory.getFile(),tree,spreadDirectory));
				this.add(addDirectory);
				JMenuItem deleteItem = new JMenuItem("Delete Directory");
				deleteItem.addActionListener(new DeleteDirectoryAction(tree));
				this.add(deleteItem);
			}
		}
	}
}
