package smart_gs.swingui;

import java.awt.BorderLayout;

import javax.swing.JPanel;

import smart_gs.menu.GSMenuBar;
import smart_gs.swingui.toolbar.GSEditorToolBar;
import smart_gs.swingui.toolbar.HistoryToolBar;
import smart_gs.swingui.toolbar.MoveTreeToolBar;
import sml_editor.swingui.EditorTextPane;

@SuppressWarnings("serial")
public class NorthPanel extends JPanel{
	
	private ToolBarPanel toolBarPanel;
	private GSMenuBar gsMenuBar;
	
	public NorthPanel(AbstractGSWindow parent){
		this.toolBarPanel = new ToolBarPanel(parent);
		this.setLayout(new BorderLayout());
		//2007/11/1 kazuhiro kobayashi
		this.gsMenuBar = new GSMenuBar(parent,toolBarPanel.getGSEditorToolBar());
		this.add(this.gsMenuBar, BorderLayout.NORTH);
		this.add(toolBarPanel);
	}
	public void setEditorTextPane(EditorTextPane textPane){
		this.toolBarPanel.setEditorTextPane(textPane);
		//2007/11/1 kazuhiro kobayashi
		this.gsMenuBar.setEditorTextPane(textPane);
	}
	
	public 	GSEditorToolBar getGSEditorToolBar(){
		return this.toolBarPanel.getGSEditorToolBar();
	}

	public 	HistoryToolBar getHistoryToolBar(){
		return this.toolBarPanel.getHistoryToolBar();
	}
	public 	MoveTreeToolBar getMoveTreeToolBar(){
		return this.toolBarPanel.getMoveTreeToolBar();
	}
}
