package smart_gs.smleditor.swingui;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;

import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

import com.hexidec.ekit.GSHTMLEditor;

import smart_gs.drawing_tool.SpreadCanvas;
import smart_gs.logical.Spread;
import smart_gs.logical.SpreadDocument;
import smart_gs.swingui.WorkspaceWindow;
import sml_editor.swingui.GSHTMLEditorTextPane;

@SuppressWarnings("serial")
public class GSTabbedPane extends JTabbedPane implements ChangeListener{
	
	protected SpreadCanvas canvas;
//	protected GSHTMLEditor transcriptionPanel;
	protected SpreadDocumentPanel transcriptionPanel;
	protected SpreadDocumentPanel annotationPanel;
	protected SpreadDocumentPanel translationPanel;
	
	protected Spread spread;
	protected GSEditorFrame parent;
	
	public GSTabbedPane(){
//		super(JTabbedPane.TOP, JTabbedPane.SCROLL_TAB_LAYOUT);
		this.add(new JPanel());
	}
	
	public GSTabbedPane(GSEditorFrame parent,Spread spread){
		this.parent = parent;
		this.spread = spread;
		this.canvas = new SpreadCanvas(spread,this);
		
//		this.transcriptionPanel = new GSHTMLEditor(parent,spread.getTranscription(),false,true,false);
		this.transcriptionPanel = new TranscriptionPanel(parent,spread.getTranscription());
		this.annotationPanel = new AnnotationPanel(parent,spread.getAnnotation());
		this.translationPanel = new TranslationPanel(parent,spread.getTranslation());
		
		this.addTab("Image",this.canvas);
		this.addTab("Transcription",this.transcriptionPanel);
		this.addTab("Annotation",this.annotationPanel);
		this.addTab("Translation",this.translationPanel);
		this.addChangeListener(this);
	}
	public SpreadCanvas getSpreadCanvas(){
		return this.canvas;
	}
	public void setSpread(Spread spread){
		this.spread = spread;
		this.canvas.setSpread(spread);
	}
	public Spread getSpread(){
		return this.spread;
	}
	public Point getCornerPoint(){
		return this.canvas.getCornerPoint();
	}
	public void setPanelToShow(int type){
		this.setSelectedIndex(type);
	}
	public void save() {
		if(this.transcriptionPanel != null){
			this.transcriptionPanel.save();
		}
		if(this.translationPanel != null){
			this.translationPanel.save();
		}
		if(this.annotationPanel != null){
			this.annotationPanel.save();
		}
	}
	
	public void emphasize(String id) {
		this.transcriptionPanel.emphasize(id);
		this.annotationPanel.emphasize(id);
		this.translationPanel.emphasize(id);
	}

	public void updateText() {
//		this.transcriptionPanel.updateText();
		this.annotationPanel.updateText();
		this.translationPanel.updateText();
	}
	public void clear(){
		if(this.transcriptionPanel != null){
			this.transcriptionPanel.removeAll();
		}
		if(this.annotationPanel != null){
			this.annotationPanel.removeAll();
		}
		if(annotationPanel != null){
			this.annotationPanel.removeAll();
		}
		if(canvas != null){
			this.canvas.clear();
			this.canvas=null;
		}
	}
	public boolean isAvailable(){
		if(canvas == null || this.transcriptionPanel == null || this.annotationPanel == null || this.translationPanel == null){
			return false;
		}
		return true;
	}
	
	public void updateTranscription(String source) {
		this.transcriptionPanel.getleftTextPane().setSource(source);
	}
	public void updateAnnotation(String source) {
		this.annotationPanel.getleftTextPane().setSource(source);
	}
	public void updateTranslation(String source) {
		this.translationPanel.getleftTextPane().setSource(source);
	}
	public String getTranscriptionSource() {
		return this.transcriptionPanel.getleftTextPane().getSource();
	}
	public String getAnnotationSource() {
		return this.annotationPanel.getleftTextPane().getSource();
	}
	public String getTranslationSource() {
		return this.translationPanel.getleftTextPane().getSource();
	}
	public GSEditorTextPane getTranscription() {
		return this.transcriptionPanel.getleftTextPane();
	}
	public GSEditorTextPane getAnnotation() {
		return this.annotationPanel.getleftTextPane();
	}
	public GSEditorTextPane getTranslation() {
		return this.translationPanel.getleftTextPane();
	}
	public void focus(){
		this.annotationPanel.jumpLinkToText(0);
	}
	
	public String getURI(){
		if(this.spread == null){
			return null;
		}
		return this.spread.getURI();
	}

	public void stateChanged(ChangeEvent e) {
		if(this.parent != null){
			Component comp = this.getComponent(this.getSelectedIndex());
			if(comp != null){
				if(comp instanceof SpreadDocumentPanel){
					if(this.parent instanceof WorkspaceWindow){
						this.parent.setEditorTextPane(((SpreadDocumentPanel)comp).getleftTextPane());
						((WorkspaceWindow)this.parent).getGSEditorToolBar().tabChanged();
					}else if(this.parent instanceof GSEditor){
						this.parent.setEditorTextPane(((SpreadDocumentPanel)comp).getleftTextPane());
						((GSEditor)this.parent).getGSEditorToolBar().tabChanged();
					}
				}else{
					if(this.parent instanceof WorkspaceWindow){
						((WorkspaceWindow)this.parent).getGSEditorToolBar().check(null);
					}else if(this.parent instanceof GSEditor){
						((GSEditor)this.parent).getGSEditorToolBar().check(null);
					}
				}
			}
		}
	}
	
	// 20080916 hashimoto.
	// ݑIĂ^uŁAJ[\^ꂽCfbNXɈړ郁\bh
	public void setCaret(int index){
		SpreadDocumentPanel panel;
		panel = (SpreadDocumentPanel)getSelectedComponent();
		panel.getleftTextPane().getGSHTMLEditorTextPane().requestFocus();
		GSHTMLEditorTextPane gsHTMLEditorTextPane;
		gsHTMLEditorTextPane = panel.getleftTextPane().getGSHTMLEditorTextPane();
		gsHTMLEditorTextPane.addFocusListener(new GSEditorFocusListener(gsHTMLEditorTextPane,(index)));
		panel.getleftTextPane().getGSHTMLEditorTextPane().requestFocus();
	}
	class GSEditorFocusListener implements FocusListener{
		protected GSHTMLEditorTextPane gsHTMLEditorTextPane;
		protected int index;
		public GSEditorFocusListener(GSHTMLEditorTextPane gsHTMLEditorTextPane,int index){
			this.gsHTMLEditorTextPane = gsHTMLEditorTextPane;
			this.index = index;
		}
		public void focusGained(FocusEvent e) {
			gsHTMLEditorTextPane.setCaretPosition(index);
			gsHTMLEditorTextPane.removeFocusListener(this);
		}
		public void focusLost(FocusEvent e) {
		}
	}
	
	public GSEditorFrame getParentFrame(){
		return parent;
	}
}


