package smart_gs.smleditor.swingui;

import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

import smart_gs.swingui.toolbar.GSMarkupAction;
import sml_editor.swingui.EditorTextPane;
import sml_editor.swingui.toolbar.action.CopyAction;
import sml_editor.swingui.toolbar.action.CutAction;
import sml_editor.swingui.toolbar.action.MarkupAction;
import sml_editor.swingui.toolbar.action.PasteAction;
import sml_editor.swingui.toolbar.action.PasteAsTextAction;

@SuppressWarnings("serial")
public class GSEditorPopupMenu2 extends JPopupMenu{	
	protected MarkupAction markupAction;
	protected CopyAction copyAction;
	protected CutAction cutAction;
	protected PasteAction pasteAction;
	protected PasteAsTextAction pasteAsTextAction;

	public GSEditorPopupMenu2(EditorTextPane textPane) {
		if(textPane.isMarkup()){
			markupAction = new GSMarkupAction();
			markupAction.setEditorTextPane(textPane);
			JMenuItem markup = new JMenuItem("Mark up");
			markup.addActionListener(markupAction);
			this.add(markup);
		}
		copyAction = new CopyAction();
		copyAction.setEditorTextPane(textPane);
		JMenuItem copy = new JMenuItem("Copy");
		copy.addActionListener(copyAction);
		this.add(copy);

		cutAction = new CutAction();
		cutAction.setEditorTextPane(textPane);
		JMenuItem cut = new JMenuItem("Cut");
		cut.addActionListener(cutAction);
		this.add(cut);

		pasteAction = new PasteAction();
		pasteAction.setEditorTextPane(textPane);
		JMenuItem paste = new JMenuItem("Paste");
		paste.addActionListener(pasteAction);
		this.add(paste);

		pasteAsTextAction = new PasteAsTextAction();
		pasteAsTextAction.setEditorTextPane(textPane);
		JMenuItem pasteAsText = new JMenuItem("Paste as Text");
		pasteAsText.addActionListener(pasteAsTextAction);
		this.add(pasteAsText);
		
	}
	
	
	
}
