package smart_gs.logical;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import java.awt.Polygon;

import smart_gs.drawing_tool.ExLine2D;
import smart_gs.drawing_tool.view.LineSegmentView;
import smart_gs.drawing_tool.view.View;



/**
 * 
 * @author kazuaki kobayashi
 *
 * Spread̍s\NX
 */
public class LineSegment extends Region{

	
	
	public LineSegment(Spread spread,List<Point2D> points){
		super(spread);
		this.points = points;
		this.createView();
	}
	
	private void createView(){
		List<ExLine2D> lines = new ArrayList<ExLine2D>();
		for(int i=0;i<this.points.size()-1;i++){
			Point2D start = this.points.get(i);
			Point2D end = this.points.get(i+1);
			ExLine2D line = new ExLine2D(start,end);
			lines.add(line);
		}
		this.view = new LineSegmentView(lines);
	}
	public Spread getSpread() {
		return this.spread;
	}
	public List<Point2D> getPoints() {
		return this.points;
	}
	public View getView(){
		return this.view;
	}
	//20100825 shimizu add
	public Polygon getPolygon(){
		Polygon polygon = new Polygon();
		for(int i=0; i<this.points.size()-1;i++){
			int x = (int)this.points.get(i).getX();
			int y = (int)this.points.get(i).getY();
			polygon.addPoint(x, y);
		}
		return polygon;
	}
	//20101110 shimizu wrote;
	public void addPoint(Point2D point){
		List<ExLine2D> lines = new ArrayList<ExLine2D>();
		for(int i=0;i<this.points.size()-1;i++){
			Point2D start = this.points.get(i);
			Point2D end = this.points.get(i+1);
			ExLine2D line = new ExLine2D(start,end);
			lines.add(line);
		}
	    double dist = lines.get(0).ptLineDist(point);
	    int x = 0;
		for(int i=1;i<lines.size();i++){
			Double d = lines.get(i).ptLineDist(point);
			if(d<dist){
				dist = d;
				x = i;
			}
			
		}
		this.points.add(x+1,point);
		this.createView();
	}
}
