package smart_gs.all_text_search;

import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.swing.JFrame;
import javax.swing.JOptionPane;

import smart_gs.logical.Presentation;
import smart_gs.logical.PresentationTree;
import smart_gs.logical.SmartDocument;
import smart_gs.logical.Spread;
import smart_gs.logical.SpreadTree;
import smart_gs.smleditor.swingui.AnnotationPanel;
import smart_gs.smleditor.swingui.GSEditor;
import smart_gs.smleditor.swingui.GSEditorTextPane;
import smart_gs.smleditor.swingui.GSTabbedPane;
import smart_gs.smleditor.swingui.GSTreeTextEditor;
import smart_gs.smleditor.swingui.GSTreeTextEditortPaneMamager;
import smart_gs.smleditor.swingui.SpreadDocumentPanel;
import smart_gs.smleditor.swingui.TranscriptionPanel;
import smart_gs.smleditor.swingui.TranslationPanel;
import smart_gs.spread_selection.SpreadSelector;
import smart_gs.swingui.GSTabbedPaneMamager;
import smart_gs.swingui.WorkspaceWindow;
import smart_gs.text_search.logical.TextSearchConstants;
import smart_gs.util.StringUtils;

public class SearchAllUtil {
	protected int documentType;
	protected int spreadnumber;
	protected int textnumber;
	protected int tabnumber;
	protected JFrame currenteditor;
	protected int scope = 0;
	protected String spreadSelection;
	protected long replaceallcounter;
	
	public SearchAllUtil(int scope,String spreadSelection){
		this.scope = scope;
		this.spreadSelection = spreadSelection;
	}
	
	public void findfirst(int documentType_){
		documentType = documentType_;
		spreadnumber = 0;
		textnumber = 0;
		tabnumber = 0;
		if(!find(true,null,false)){
			JOptionPane.showMessageDialog(new JFrame(), "String Not Found", "Information", JOptionPane.INFORMATION_MESSAGE);
		}
	}

	public void setstart(){
		textnumber = 0;
		spreadnumber = 0;
		tabnumber =0;
	}
	
	public void setTextNumber(int textnumber){
		this.textnumber = textnumber;
	}
	public void setSpreadnumber(int spreadnumber){
		this.spreadnumber = spreadnumber;
	}
	public void setTabnumber(int tabnumber){
		this.tabnumber = tabnumber;
	}
	public void setCurrentEditor(JFrame currenteditor){
		this.currenteditor = currenteditor;
	}
	public boolean  nextrelaceall(){
		tabnumber++;
		boolean isFind = false;
		isFind = find(true,null,true);
		if(!isFind){
//			tabnumber = 0;
//			isFind = find(true,null,true);
		}
		return isFind;
	}
	
	public boolean relaceallnonewwindows(final String replace){
		replaceallcounter = 0;
		ArrayList<Presentation> arrList = (ArrayList<Presentation>) PresentationTree.getInstance().getPresentations();
		List<Spread> list = getSpreadsToSearch();
		if( documentType == TextSearchConstants.TRANSCRIPTION ||
				documentType == TextSearchConstants.ANNOTATION ||
				documentType == TextSearchConstants.TRANSLATION ||
				documentType == TextSearchConstants.ALLDOCUMENT){
				for(int i=0;i<list.size();i++){
					Spread spread = list.get(i);
					if(spread == null){
						continue;
					}
					replaceallprocess(spread,replace);
				}
		}
		if(scope != 0){
			JOptionPane.showMessageDialog(SearchAllDialogManager.getDialog(), replaceallcounter + " matches replaced", "Information", JOptionPane.INFORMATION_MESSAGE);
			return false;
		}
		if(documentType == TextSearchConstants.TEXT || documentType == TextSearchConstants.ALLDOCUMENT){
			for(int i=0;i<arrList.size();i++){
				Presentation presentation = arrList.get(i);
				if(presentation == null){
					continue;
				}
				replacealltextprocess(presentation,replace);
			}
		}
		JOptionPane.showMessageDialog(SearchAllDialogManager.getDialog(), replaceallcounter + " matches replaced", "Information", JOptionPane.INFORMATION_MESSAGE);
		return false;
	}
	
	public List<Spread> getSpreadsToSearch(){
		if(scope == 0){
			return SpreadTree.getInstance().getSpreads();
		}
		else if(scope == 1){
			return SpreadTree.getInstance().getCurrentDirectory().getSpreads();
		}
		else if(scope == 2){
			SpreadSelector selector = new SpreadSelector( SpreadTree.getInstance().getSpreads(), spreadSelection);
			return selector.select();
		}
		return null;
	}
	
	
	public boolean next(final String replace){
		tabnumber++;
		boolean isFind = false;
		isFind = find(true,replace,false);
		if(!isFind){
			textnumber = 0;
			spreadnumber = 0;
			tabnumber = 0;
			isFind = find(true,replace,false);
		}
		return isFind;
	}
	public boolean prev(final String replace){
		tabnumber--;
		textnumber--;
		boolean isFind = false;
		isFind = find(false,replace,false);
		if(!isFind){
			List<Spread> list = getSpreadsToSearch();
			ArrayList<Presentation> arrList = (ArrayList<Presentation>) PresentationTree.getInstance().getPresentations();
			textnumber = (arrList.size() -1);
			spreadnumber = (list.size() - 1);
			tabnumber = 99;
			isFind = find(false,replace,false);
		}
		return isFind;
	}
	public boolean find(boolean way,final String replace,boolean relaceallmode){
		ArrayList<Presentation> arrList = (ArrayList<Presentation>) PresentationTree.getInstance().getPresentations();
		List<Spread> list = getSpreadsToSearch();
		if(way){
			if( documentType == TextSearchConstants.TRANSCRIPTION ||
				documentType == TextSearchConstants.ANNOTATION ||
				documentType == TextSearchConstants.TRANSLATION ||
				documentType == TextSearchConstants.ALLDOCUMENT){
				for(int i=spreadnumber;i<list.size();i++){
					Spread spread = list.get(i);
					if(spread == null){
						continue;
					}
					if(findprocess(spread,way,replace,relaceallmode)){
						spreadnumber = i;
						return true;
					}else{
						if(relaceallmode){
							tabnumber = 0;
						}
						continue;
					}
				}
			}
			if(scope != 0){
				return false;
			}
			if(documentType == TextSearchConstants.TEXT || documentType == TextSearchConstants.ALLDOCUMENT){
				if(textnumber < 0){
					textnumber = 0;
				}
				for(int i=textnumber;i<arrList.size();i++){
					Presentation presentation = arrList.get(i);
					if(presentation == null){
						continue;
					}
					if(findtextprocess(presentation,way,replace,relaceallmode)){
						return true;
					}else{
						continue;
					}
				}

			}
			return false;
		}else{
			if( documentType == TextSearchConstants.TRANSCRIPTION ||
				documentType == TextSearchConstants.ANNOTATION ||
				documentType == TextSearchConstants.TRANSLATION ||
				documentType == TextSearchConstants.ALLDOCUMENT){
				for(int i=spreadnumber;i>=0;i--){
					Spread spread = list.get(i);
					if(spread == null){
						continue;
					}
					if(findprocess(spread,way,replace,relaceallmode)){
						spreadnumber = i;
						return true;
					}else{
						tabnumber = 99;
						continue;
					}
				}
			}
			if(scope != 0){
				return false;
			}
			if(documentType == TextSearchConstants.TEXT || documentType == TextSearchConstants.ALLDOCUMENT){
				for(int i=textnumber;i>=0;i--){
					Presentation presentation = arrList.get(i);
					if(presentation == null){
						continue;
					}
					if(findtextprocess(presentation,way,replace,relaceallmode)){
						textnumber = i;
						return true;
					}else{
						continue;
					}
				}

			}

			return false;
		}
	}
	protected boolean issearch=false;
	protected boolean findprocess(Spread spread,boolean way,final String replace,boolean relaceallmode){
		Component selectedComponent = null;
		// WorkspaceWindow.getInstance().tabbedPaneSave();
		
	    GSEditor editor = findWindow(spread.getURI());
	    // łWindowJĂꍇ͂̐ݒɂ䂾˂

	    // ALL͂ǂŌLĂ
	    ArrayList<Integer> foundnumberList = new ArrayList<Integer>();
	    //WindowsJOɗ\ߌΏۂ̕񂪂邩mFB
	    if(documentType == TextSearchConstants.TRANSCRIPTION){
    		boolean html = false;
    		if(editor != null){
    			GSTabbedPane tabbedPane = editor.getSMLTabbedPane();
    			if(tabbedPane.getSelectedComponent() instanceof TranscriptionPanel){
	    			if(editor.getGSEditorToolBar().getMode() == 2){
	    				html = true;
	    			}
    			}
    			if(html){
    				if(!findcheck(tabbedPane.getTranscriptionSource(),true)){
            			return false;
            		}
    			}else{
            		if(!findcheck(spread.getTranscription().getSource(),html)){
            			return false;
            		}
    			}
    		}else{
        		if(!findcheck(spread.getTranscription().getSource(),html)){
        			return false;
        		}
    		}
		}else if(documentType == TextSearchConstants.ANNOTATION){
    		boolean html = false;
    		if(editor != null){
    			GSTabbedPane tabbedPane = editor.getSMLTabbedPane();
    			if(tabbedPane.getSelectedComponent() instanceof AnnotationPanel){
	    			if(editor.getGSEditorToolBar().getMode() == 2){
	    				html = true;
	    			}
    			}
    			if(html){
    				if(!findcheck(tabbedPane.getAnnotationSource(),true)){
            			return false;
            		}
    			}else{
            		if(!findcheck(spread.getAnnotation().getSource(),html)){
            			return false;
            		}
    			}
    		}else{
	    		if(!findcheck(spread.getAnnotation().getSource(),html)){
	    			return false;
	    		}
    		}
		}else if(documentType == TextSearchConstants.TRANSLATION){
    		boolean html = false;
    		if(editor != null){
    			GSTabbedPane tabbedPane = editor.getSMLTabbedPane();
    			if(tabbedPane.getSelectedComponent() instanceof TranslationPanel){
	    			if(editor.getGSEditorToolBar().getMode() == 2){
	    				html = true;
	    			}
    			}
    			if(html){
    				if(!findcheck(tabbedPane.getTranscriptionSource(),true)){
            			return false;
            		}
    			}else{
            		if(!findcheck(spread.getTranslation().getSource(),false)){
            			return false;
            		}
    			}

    		}else{
	    		if(!findcheck(spread.getTranslation().getSource(),false)){
	    			return false;
	    		}
    		}
		}else if(documentType == TextSearchConstants.ALLDOCUMENT){
			boolean allFind = false;
			{
	    		boolean html = false;
	    		if(editor != null){
	    			GSTabbedPane tabbedPane = editor.getSMLTabbedPane();
	    			if(tabbedPane.getSelectedComponent() instanceof TranscriptionPanel){
		    			if(editor.getGSEditorToolBar().getMode() == 2){
		    				html = true;
		    			}
	    			}
	    			if(html){
	    				if(findcheck(tabbedPane.getTranscriptionSource(),true)){
			    			allFind = true;
			    			foundnumberList.add(new Integer(1));
	            		}
	    			}else{
	            		if(findcheck(spread.getTranscription().getSource(),false)){
			    			allFind = true;
			    			foundnumberList.add(new Integer(1));
	            		}
	    			}
	    		}else{
		    		if(findcheck(spread.getTranscription().getSource(),false)){
		    			allFind = true;
		    			foundnumberList.add(new Integer(1));
		    		}
	    		}
				
			}
			{
	    		boolean html = false;
	    		if(editor != null){
	    			GSTabbedPane tabbedPane = editor.getSMLTabbedPane();
	    			if(tabbedPane.getSelectedComponent() instanceof AnnotationPanel){
		    			if(editor.getGSEditorToolBar().getMode() == 2){
		    				html = true;
		    			}
	    			}
	    			if(html){
	    				if(findcheck(tabbedPane.getAnnotationSource(),true)){
			    			allFind = true;
			    			foundnumberList.add(new Integer(2));
	            		}
	    			}else{
	            		if(findcheck(spread.getAnnotation().getSource(),false)){
			    			allFind = true;
			    			foundnumberList.add(new Integer(2));
	            		}
	    			}
	    		}else{
		    		if(findcheck(spread.getAnnotation().getSource(),false)){
		    			allFind = true;
		    			foundnumberList.add(new Integer(2));
					}
	    		}
			}
			{
	    		boolean html = false;
	    		if(editor != null){
	    			GSTabbedPane tabbedPane = editor.getSMLTabbedPane();
	    			if(tabbedPane.getSelectedComponent() instanceof TranslationPanel){
		    			if(editor.getGSEditorToolBar().getMode() == 2){
		    				html = true;
		    			}
	    			}
	    			if(html){
	    				if(findcheck(tabbedPane.getTranscriptionSource(),true)){
			    			allFind = true;
			    			foundnumberList.add(new Integer(3));
	            		}
	    			}else{
	            		if(findcheck(spread.getTranslation().getSource(),false)){
			    			allFind = true;
			    			foundnumberList.add(new Integer(3));
	            		}
	    			}
	    		}else{
		    		if(findcheck(spread.getTranslation().getSource(),false)){
		    			allFind = true;
		    			foundnumberList.add(new Integer(3));
		    		}
	    		}
			}
    		if(!allFind){
    			return false;
    		}
		}
	    boolean isNewWindow = false;
	    if(editor == null){
	    	editor = new GSEditor(spread);
	    	isNewWindow = true;
	    }
		GSTabbedPane tabbedPane = editor.getSMLTabbedPane();
		int count = tabbedPane.getComponentCount();
		if(documentType == TextSearchConstants.TRANSCRIPTION){
			if(way){
				for(int j=tabnumber;j<count;j++){
					Component component = tabbedPane.getComponent(j);
					if(component instanceof TranscriptionPanel){
						selectedComponent = component;
						tabnumber = j;
						break;
					}
				}
			}else{
				if(tabnumber >= count){
					tabnumber = (count - 1);
				}	for(int j=tabnumber;j>=0;j--){
					Component component = tabbedPane.getComponent(j);
					if(component instanceof TranscriptionPanel){
						selectedComponent = component;
						tabnumber = j;
						break;
					}
				}
			}
			
		}else if(documentType == TextSearchConstants.ANNOTATION){
			if(way){
				for(int j=tabnumber;j<count;j++){
					Component component = tabbedPane.getComponent(j);
					if(component instanceof AnnotationPanel){
						selectedComponent = component;
						tabnumber = j;
						break;
					}
				}
			}else{
				if(tabnumber >= count){
					tabnumber = (count - 1);
				}
				for(int j=tabnumber;j>=0;j--){
					Component component = tabbedPane.getComponent(j);
					if(component instanceof AnnotationPanel){
						selectedComponent = component;
						tabnumber = j;
						break;
					}
				}
				
			}
		}else if(documentType == TextSearchConstants.TRANSLATION){
			if(way){
				for(int j=tabnumber;j<count;j++){
					Component component = tabbedPane.getComponent(j);
					if(component instanceof TranslationPanel){
						selectedComponent = component;
						tabnumber = j;
						break;
					}
				}
			}else{
				if(tabnumber >= count){
					tabnumber = (count - 1);
				}				for(int j=tabnumber;j>=0;j--){
					Component component = tabbedPane.getComponent(j);
					if(component instanceof TranslationPanel){
						selectedComponent = component;
						tabnumber = j;
						break;
					}
				}
			}
		}else if(documentType == TextSearchConstants.ALLDOCUMENT){
			if(way){
				for(int j=tabnumber;j<count;j++){
					Component component = tabbedPane.getComponent(j);
					if(component instanceof TranscriptionPanel){
						if(foundnumberList.contains(new Integer(1))){
							selectedComponent = component;
							tabnumber = j;
							break;
						}
					}else if(component instanceof AnnotationPanel){
						if(foundnumberList.contains(new Integer(2))){
							selectedComponent = component;
							tabnumber = j;
							break;
						}
					}else if(component instanceof TranslationPanel){
						if(foundnumberList.contains(new Integer(3))){
							selectedComponent = component;
							tabnumber = j;
							break;
						}
					}
				}
			}else{
				if(tabnumber >= count){
					tabnumber = (count - 1);
				}
				for(int j=tabnumber;j>=0;j--){
					Component component = tabbedPane.getComponent(j);
					if(component instanceof TranscriptionPanel){
						if(foundnumberList.contains(new Integer(1))){
							selectedComponent = component;
							tabnumber = j;
							break;
						}
					}else if(component instanceof AnnotationPanel){
						if(foundnumberList.contains(new Integer(2))){
							selectedComponent = component;
							tabnumber = j;
							break;
						}
					}else if(component instanceof TranslationPanel){
						if(foundnumberList.contains(new Integer(3))){
							selectedComponent = component;
							tabnumber = j;
							break;
						}
					}
				}
								
			}
		}
		if(selectedComponent != null){
			SearchAllDialogManager.clearselect();
			tabbedPane.setSelectedIndex(tabnumber);
			SearchAllDialogManager.setEditor(editor,editor.getGSEditorToolBar());
			SearchAllDialogManager.visible();
			if(selectedComponent instanceof SpreadDocumentPanel){
				final GSEditorTextPane textPane = ((SpreadDocumentPanel)selectedComponent).getleftTextPane();
				// tH[JXCxgʒm
				if(!editor.isVisible()){
					editor.setLocationByPlatform(true);
				}
				editor.setVisible(true);
				textPane.getGSHTMLEditorTextPane().requestFocusInWindow(); 
				if(!relaceallmode){
					editor.addWindowListener(new WindowAdapter() {
					  @Override
					  public void windowOpened(WindowEvent e) {
						  SearchAllDialogManager.search(replace);
					  }
					});
					if(!isNewWindow){
						SearchAllDialogManager.search(replace);
					}
				}
			}
			return true;
		}
		if(way){
			if(count >= tabnumber){
				tabnumber = 0;
//				spreadnumber++;
			}else{
				tabnumber++;
			}
		}else{
			if(tabnumber == 0){
				tabnumber = count;
				spreadnumber--;
			}else{
				tabnumber--;
			}
		}
		return false;
	}
	

	public boolean findtextprocess(Presentation presentation,boolean way,final String replace,boolean relaceallmode){
		GSTreeTextEditor editor = GSTreeTextEditortPaneMamager.getGSTreeTextEditort(String.valueOf(((SmartDocument)presentation).getId()));
	    // łWindowJĂꍇ͂̐ݒɂ䂾˂

	    //WindowsJOɗ\ߌΏۂ̕񂪂邩mFB
		boolean html = false;
		boolean isNewWindow = false;
		if(editor != null){
			if(editor.getGSEditorToolBar().getMode() == 2){
				html = true;
			}
			if(html){
				if(!findcheck(editor.getGSEditorTextPane().getSource(),true)){
					return false;
				}
			}else{
        		if(!findcheck(editor.getGSEditorTextPane().getPainText(),true)){
					return false;
        		}
			}
		}else{
			if(!findcheck(presentation.getSource(),false)){
				return false;
			}
			
		}
	    if(editor == null){
	    	editor = new GSTreeTextEditor(presentation,presentation.getName());
	    	isNewWindow = true;
	    }
		SearchAllDialogManager.clearselect();
		SearchAllDialogManager.setEditor(editor,editor.getGSEditorToolBar());
		SearchAllDialogManager.visible();
		final GSEditorTextPane gsEditorTextPane = editor.getGSEditorTextPane();
		// tH[JXCxgʒm
		if(!editor.isVisible()){
			editor.setLocationByPlatform(true);
		}
		editor.setVisible(true);
		gsEditorTextPane.getGSHTMLEditorTextPane().requestFocusInWindow();
		if(!relaceallmode){
			if(isNewWindow){
				editor.addWindowListener(new WindowAdapter() {
					  @Override
					  public void windowOpened(WindowEvent e) {
						  SearchAllDialogManager.search(replace);
					  }
				});
			}else{
//				SearchAllDialogManager.search();
				WindowEvent aEvent = new WindowEvent(editor, WindowEvent.WINDOW_OPENED);
				Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(aEvent);
			}
		}
		if(way){
			textnumber++;
		}else{
			textnumber--;
		}
		return true;
	}
	
	protected boolean replaceallprocess(Spread spread,final String replace){
		// WorkspaceWindow.getInstance().tabbedPaneSave();
		boolean isFind = false;
		
		GSEditor editor = findWindow(spread.getURI());
		WorkspaceWindow workspaceWindow = null;
		if(editor != null){
			editor.getSMLTabbedPane().save();
		}else{
			workspaceWindow = findWorkspaceWindow(spread.getURI());
		}
		// EditorJĂꍇ́A̒gւ
		// JĂȂꍇsoread̒gւ.
		if(documentType == TextSearchConstants.TRANSCRIPTION){
	    	ReplaceALLInfo replaceALLInfo;
	    	if(editor != null || workspaceWindow != null){
	    		GSTabbedPane gsTabbedPane = null;
	    		if(editor != null){
	    			gsTabbedPane = editor.getSMLTabbedPane();
	    		}else if(workspaceWindow != null){
	    			gsTabbedPane = workspaceWindow.getTabbedPane();
	    		}
	    		if(gsTabbedPane != null){
		    		// No Windows[h͑SĂTextƂĈ߁AEdittrueɒւ
	    			gsTabbedPane.getTranscription().setEdit(true);
		    		replaceALLInfo = replace(gsTabbedPane.getTranscription().getSource("body"),replace);
		    		if(replaceALLInfo.isReplace()){
		    			int oldCaretPosition = gsTabbedPane.getTranscription().getCaretPosition();
		    			gsTabbedPane.getTranscription().setSource(replaceALLInfo.getSource());
		    			gsTabbedPane.getTranscription().setCaretPosition(oldCaretPosition);
			    		isFind = true;
			    	}
	    		}
	    	}else{
	    		replaceALLInfo = replace(spread.getTranscription().getLeftPageSource(),replace);
		    	if(replaceALLInfo.isReplace()){
		    		spread.getTranscription().setLeftSource(replaceALLInfo.getSource());
		    		isFind = true;
		    	}
	    	}
		}else if(documentType == TextSearchConstants.ANNOTATION){
	    	ReplaceALLInfo replaceALLInfo;
	    	if(editor != null || workspaceWindow != null){
	    		GSTabbedPane gsTabbedPane = null;
	    		if(editor != null){
	    			gsTabbedPane = editor.getSMLTabbedPane();
	    		}else if(workspaceWindow != null){
	    			gsTabbedPane = workspaceWindow.getTabbedPane();
	    		}
	    		if(gsTabbedPane != null){
		    		// No Windows[h͑SĂTextƂĈ߁AEdittrueɒւ
	    			gsTabbedPane.getAnnotation().setEdit(true);
		    		replaceALLInfo = replace(gsTabbedPane.getAnnotation().getSource("body"),replace);
		    		if(replaceALLInfo.isReplace()){
		    			int oldCaretPosition = gsTabbedPane.getAnnotation().getCaretPosition();
		    			gsTabbedPane.getAnnotation().setSource(replaceALLInfo.getSource());
		    			gsTabbedPane.getAnnotation().setCaretPosition(oldCaretPosition);
			    		isFind = true;
			    	}
	    		}
	    	}else{		    	
	    		replaceALLInfo = replace(spread.getAnnotation().getSource(),replace);
		    	if(replaceALLInfo.isReplace()){
		    		spread.getAnnotation().setSource(replaceALLInfo.getSource());
		    		isFind = true;
		    	}
	    	}
		}else if(documentType == TextSearchConstants.TRANSLATION){
	    	ReplaceALLInfo replaceALLInfo;
	    	if(editor != null || workspaceWindow != null){
	    		GSTabbedPane gsTabbedPane = null;
	    		if(editor != null){
	    			gsTabbedPane = editor.getSMLTabbedPane();
	    		}else if(workspaceWindow != null){
	    			gsTabbedPane = workspaceWindow.getTabbedPane();
	    		}
	    		if(gsTabbedPane != null){
		    		// No Windows[h͑SĂTextƂĈ߁AEdittrueɒւ
	    			gsTabbedPane.getTranslation().setEdit(true);
		    		replaceALLInfo = replace(gsTabbedPane.getTranslation().getSource("body"),replace);
		    		if(replaceALLInfo.isReplace()){
		    			int oldCaretPosition = gsTabbedPane.getTranslation().getCaretPosition();
		    			gsTabbedPane.getTranslation().setSource(replaceALLInfo.getSource());
		    			gsTabbedPane.getTranslation().setCaretPosition(oldCaretPosition);
			    		isFind = true;
			    	}
	    		}
	    	}else{
		    	replaceALLInfo = replace(spread.getTranslation().getSource(),replace);
		    	if(replaceALLInfo.isReplace()){
		    		spread.getTranslation().setSource(replaceALLInfo.getSource());
		    		isFind = true;
		    	}
	    	}
		}else if(documentType == TextSearchConstants.ALLDOCUMENT){
	    	ReplaceALLInfo replaceALLInfo;
	    	if(editor != null || workspaceWindow != null){
	    		GSTabbedPane gsTabbedPane = null;
	    		if(editor != null){
	    			gsTabbedPane = editor.getSMLTabbedPane();
	    		}else if(workspaceWindow != null){
	    			gsTabbedPane = workspaceWindow.getTabbedPane();
	    		}
	    		if(gsTabbedPane != null){
		    		// No Windows[h͑SĂTextƂĈ߁AEdittrueɒւ
	    			gsTabbedPane.getTranscription().setEdit(true);
		    		replaceALLInfo = replace(gsTabbedPane.getTranscription().getSource("body"),replace);
		    		if(replaceALLInfo.isReplace()){
		    			int oldCaretPosition = gsTabbedPane.getTranscription().getCaretPosition();
		    			gsTabbedPane.getTranscription().setSource(replaceALLInfo.getSource());
		    			gsTabbedPane.getTranscription().setCaretPosition(oldCaretPosition);
			    		isFind = true;
			    	}
	    		}
	    	}else{
	    		replaceALLInfo = replace(spread.getTranscription().getLeftPageSource(),replace);
		    	if(replaceALLInfo.isReplace()){
		    		spread.getTranscription().setLeftSource(replaceALLInfo.getSource());
		    		isFind = true;
		    	}
	    	}
	    	if(editor != null || workspaceWindow != null){
	    		GSTabbedPane gsTabbedPane = null;
	    		if(editor != null){
	    			gsTabbedPane = editor.getSMLTabbedPane();
	    		}else if(workspaceWindow != null){
	    			gsTabbedPane = workspaceWindow.getTabbedPane();
	    		}
	    		if(gsTabbedPane != null){
		    		// No Windows[h͑SĂTextƂĈ߁AEdittrueɒւ
	    			gsTabbedPane.getAnnotation().setEdit(true);
		    		replaceALLInfo = replace(gsTabbedPane.getAnnotation().getSource("body"),replace);
		    		if(replaceALLInfo.isReplace()){
		    			int oldCaretPosition = gsTabbedPane.getAnnotation().getCaretPosition();
		    			gsTabbedPane.getAnnotation().setSource(replaceALLInfo.getSource());
		    			gsTabbedPane.getAnnotation().setCaretPosition(oldCaretPosition);
			    		isFind = true;
			    	}
	    		}
	    	}else{		    	
	    		replaceALLInfo = replace(spread.getAnnotation().getSource(),replace);
		    	if(replaceALLInfo.isReplace()){
		    		spread.getAnnotation().setSource(replaceALLInfo.getSource());
		    		isFind = true;
		    	}
	    	}
	    	if(editor != null || workspaceWindow != null){
	    		GSTabbedPane gsTabbedPane = null;
	    		if(editor != null){
	    			gsTabbedPane = editor.getSMLTabbedPane();
	    		}else if(workspaceWindow != null){
	    			gsTabbedPane = workspaceWindow.getTabbedPane();
	    		}
	    		if(gsTabbedPane != null){
		    		// No Windows[h͑SĂTextƂĈ߁AEdittrueɒւ
	    			gsTabbedPane.getTranslation().setEdit(true);
		    		replaceALLInfo = replace(gsTabbedPane.getTranslation().getSource("body"),replace);
		    		if(replaceALLInfo.isReplace()){
		    			int oldCaretPosition = gsTabbedPane.getTranslation().getCaretPosition();
		    			gsTabbedPane.getTranslation().setSource(replaceALLInfo.getSource());
		    			gsTabbedPane.getTranslation().setCaretPosition(oldCaretPosition);
			    		isFind = true;
			    	}
	    		}
	    	}else{
		    	replaceALLInfo = replace(spread.getTranslation().getSource(),replace);
		    	if(replaceALLInfo.isReplace()){
		    		spread.getTranslation().setSource(replaceALLInfo.getSource());
		    		isFind = true;
		    	}
	    	}
		}
		return isFind;
	}

	public boolean replacealltextprocess(Presentation presentation,final String replace){
		boolean isFind = false;
		GSTreeTextEditor editor = GSTreeTextEditortPaneMamager.getGSTreeTextEditort(String.valueOf(((SmartDocument)presentation).getId()));
		ReplaceALLInfo replaceALLInfo;
    	if(editor != null){
    		GSEditorTextPane gsEditorTextPane = null;
    		if(editor != null){
    			gsEditorTextPane = editor.getGSEditorTextPane();
    		}
    		if(gsEditorTextPane != null){
	    		// No Windows[h͑SĂTextƂĈ߁AEdittrueɒւ
    			gsEditorTextPane.setEdit(true);
	    		replaceALLInfo = replace(gsEditorTextPane.getSource("body"),replace);
	    		if(replaceALLInfo.isReplace()){
	    			int oldCaretPosition = gsEditorTextPane.getCaretPosition();
	    			gsEditorTextPane.setSource(replaceALLInfo.getSource());
	    			gsEditorTextPane.setCaretPosition(oldCaretPosition);
		    		isFind = true;
		    	}
    		}
    	}else{
    		replaceALLInfo = replace(presentation.getSource(),replace);
	    	if(replaceALLInfo.isReplace()){
	    		presentation.setSource(replaceALLInfo.getSource());
	    		isFind = true;
	    	}
    	}
		return isFind;
	}

	protected ReplaceALLInfo replace(String source,String replace){
		ReplaceALLInfo replaceALLInfo = new ReplaceALLInfo();
		boolean isFind = false;
		String queryText = SearchAllDialogManager.getSearchTextField();
		// isCaseSensitive̒lɏ]queryText, planeTextϊ
		String ccQuery = convertCase(queryText, SearchAllDialogManager.isCaseCheckBox());
		String text = source;
		StringBuffer buf = new StringBuffer();
		boolean tagmode = false;
		StringBuffer matchBuf = new StringBuffer();
		for(int i=0;i<text.length();i++){
			if(text.charAt(i) == '<'){
				tagmode = true;
				buf.append(matchBuf.toString());
				matchBuf = new StringBuffer(); 
			}
			if(tagmode){
				buf.append(text.charAt(i));
			}else{
				matchBuf.append(text.charAt(i));
				int matchIndex;
				if(SearchAllDialogManager.isRegularCheckBox()){
					Pattern p = Pattern.compile(ccQuery);
					Matcher m = null;
					if(SearchAllDialogManager.isCaseCheckBox()){
						m = p.matcher(matchBuf.toString());
					}else{
						m = p.matcher(matchBuf.toString().toLowerCase());
					}
					if(m.find()){
						replaceallcounter++;
						buf.append(m.replaceAll(replace));
						isFind = true;
						matchBuf = new StringBuffer(); 
					}
				}else{
					if(SearchAllDialogManager.isCaseCheckBox()){
						matchIndex = matchBuf.toString().indexOf(ccQuery);
					}else{
						matchIndex = matchBuf.toString().toLowerCase().indexOf(ccQuery);
					}
					if(matchIndex != -1){
						replaceallcounter++;
						buf.append(StringUtils.replaceString(matchBuf.toString(),ccQuery,replace));
						isFind = true;
						matchBuf = new StringBuffer(); 
					}
				}
			}
			if(text.charAt(i) == '>'){
				tagmode = false;
			}
		}
		buf.append(matchBuf.toString());
		replaceALLInfo.setSource(buf.toString());
		replaceALLInfo.setReplace(isFind);
		return replaceALLInfo;

	}

	public GSEditor findWindow(String url){
		GSTabbedPane newTabbedPane = GSTabbedPaneMamager.getGSTabbedPane(url);
		if(newTabbedPane == null){
			return null;
		}
		if(newTabbedPane.getParentFrame() instanceof GSEditor){
			return (GSEditor)newTabbedPane.getParentFrame();
		}
		return null;
	}

	public WorkspaceWindow findWorkspaceWindow(String url){
		GSTabbedPane newTabbedPane = GSTabbedPaneMamager.getGSTabbedPane(url);
		if(newTabbedPane == null){
			return null;
		}
		if(newTabbedPane.getParentFrame() instanceof WorkspaceWindow){
			if(((WorkspaceWindow)newTabbedPane.getParentFrame()).getSpread().getURI().equals(url)){
				return (WorkspaceWindow)newTabbedPane.getParentFrame();
			}
		}
		return null;
	}

	private  boolean findcheck(String source,boolean isSource){
		String queryText = SearchAllDialogManager.getSearchTextField();
		String planeText = null;
		if(isSource){
			planeText = source;
		}else{
			planeText = source2Text(source);
		}
		// isCaseSensitive̒lɏ]queryText, planeTextϊ
		String ccQuery = convertCase(queryText, SearchAllDialogManager.isCaseCheckBox());
		String ccText = convertCase(planeText, SearchAllDialogManager.isCaseCheckBox());
    	
    	if(SearchAllDialogManager.isRegularCheckBox()){
			try{
				Pattern p = Pattern.compile(ccQuery);
				Matcher m = p.matcher(ccText);
			    while(m.find()){
			    	return true;
			    }
			}catch(Exception e){
				e.printStackTrace();
				return false;
			}
		}else{
			if (ccText.indexOf(ccQuery) != -1) {
				return true;
			}
		}
    	return false;
	}
	
	private static String source2Text(String source) {
		String planeText = source;
		planeText = StringUtils.replaceString(planeText, "<br>", "\n");
		Pattern pattern = Pattern.compile("<.+?>", Pattern.DOTALL);
		Matcher matcher = pattern.matcher(planeText);
		planeText = matcher.replaceAll("");
		return planeText;
	}

	private static String convertCase(String source, boolean isCaseSensitive) {
		if (source == null) {
			return null;
		}
		if (isCaseSensitive) {
			return source;
		}
		return source.toLowerCase();
	}
}
