package reasoning_web.logical;

import reasoning_web.logical.inter_face.RWElement;

public class Connection implements RWElement{
	
	protected ExplanatoryNote expNote;
	protected ResourcePointer source;
	protected ResourcePointer target;
	protected String name = "";
	
	protected int dependency;
	
	public static final int SOURCE_TO_TARGET = 0;   // sourcetargetɈˑ
	public static final int TARGET_TO_SOURCE = 1;   // targetsoruceɈˑ
	
	protected Connection(ResourcePointer source,ResourcePointer target,ExplanatoryNote note,int dependency) {
		this.source = source;
		this.target = target;
		this.source.addTarget(target);
		this.target.addSource(source);
		this.source.addConnection(this);
		this.target.addConnection(this);
		this.expNote = note;
		this.dependency = dependency;         //validȒl̃`FbN

	}
	public void setName(String name){
		this.name = name;
	}
	public String getName(){
		return this.name;
	}
	public ExplanatoryNote getExplanatoryNote(){
		return this.expNote;
	}
	public ResourcePointer getSourcePointer(){
		return source;
	}
	public ResourcePointer getTargetPointer() {
		return target;
	}
	//20080521 shimizu localviewJƂɃN̎ނʂł悤ύXB;
	public ResourcePointer getOppositePointer(ResourcePointer pointer){
		if(pointer.equals(this.source)){
			this.target.position = 0;
			return this.target;
		}else if(pointer.equals(this.target)){
			this.source.position = 1;
			return this.source;
		}
		return null;
	}
	
	public String getSource() throws NotMarkupException {
		throw new NotMarkupException();
	}
	
	/**
	 * 
	 * @param pointer
	 * @return pointerˑĂvfԂ
	 */
	public ResourcePointer getDependentResource(ResourcePointer pointer){
		if(pointer.equals(this.source) && this.dependency == SOURCE_TO_TARGET){
			return this.target;
		}else if(pointer.equals(this.target) && this.dependency == TARGET_TO_SOURCE){
			return this.source;
		}
		return null;
	}
	
	/**
	 * 
	 * @param pointer
	 * @return pointerɈˑĂvfԂ
	 */
	public ResourcePointer getBackwardDependentResource(ResourcePointer pointer){
		if(pointer.equals(this.source) && this.dependency == TARGET_TO_SOURCE){
			return this.target;
		}else if(pointer.equals(this.target) && this.dependency == SOURCE_TO_TARGET){
			return this.source;
		}
		return null;
	}
}
