package image_editor.toolbar;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Color;
import java.awt.BasicStroke;

public class DrawFreeLineCommand implements DrawCommand {
	private int sx, sy, ex, ey;
	private float WIDTH = 1f;
	private Color color = Color.black;
	
//	public static final int DARK = 0;
//	public static final int BRIGHT = 1;
	
	public DrawFreeLineCommand(int sx, int sy, int ex, int ey){
		this.sx = sx;
		this.sy = sy;
		this.ex = ex;
		this.ey = ey;
	}
	public void execute(Graphics g) {
		// TODO Auto-generated method stub
		//kazuhiro kobayashi 10/2
		Graphics2D g2 = (Graphics2D)g;
		Color oldColor = g2.getColor();
		g2.setStroke(new BasicStroke(WIDTH, BasicStroke.CAP_ROUND, BasicStroke.JOIN_ROUND));
		g2.setColor(this.color);
		g2.drawLine(sx, sy, ex, ey);
		g2.setColor(oldColor);
	}
	public void setColor(Color color){
		this.color = color;
	}
	public  void setWidth(float width){
		this.WIDTH = width;
	}
//	public void changeColorDepth(int depth){
//		if(depth == DARK){
//			this.color = this.color.darker();
//		}
//		else if(depth == BRIGHT){
//			this.color = this.color.brighter();
//		}
//	}

}
