package image_editor;

import image_editor.toolbar.CutCommand;
import image_editor.toolbar.DrawCommand;
import image_editor.toolbar.PasteImageCommand;
import image_editor.toolbar.SelectedRectangleView;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.awt.image.CropImageFilter;
import java.awt.image.FilteredImageSource;
import java.util.List;
import java.util.Vector;

import javax.swing.ImageIcon;
import javax.swing.JLabel;


@SuppressWarnings("serial")

public class EditorCanvas extends JLabel implements MouseListener,MouseMotionListener{

	private Image offImage;
	private Graphics offg;
	
	private int imageWidth;
	private int imageHeight;
	
	private List<DrawCommand> commands;	
	private Mode mode;	
	
	private SelectedRectangleView selectedRect = null;
	
	private Graphics clipg ;
	private Image clippedImage = null;
	private int clippedWidth;
	private int clippedHeight;
	
	private List<PasteImageCommand> pastedImages;
	
	public EditorCanvas(Image image,int width,int height){
		super((new ImageIcon(image)));
		this.mode = DefaultMode.getInstance();
		this.commands = new Vector<DrawCommand>();
		this.pastedImages = new Vector<PasteImageCommand>();
		this.imageWidth = width;
		this.imageHeight = height;
		this.offImage = new BufferedImage(this.imageWidth,this.imageHeight,BufferedImage.TYPE_INT_RGB);
		this.offg = this.offImage.getGraphics();
		
		
		this.addMouseListener(this);
		this.addMouseMotionListener(this);
	}
	@Override
	public void paint(Graphics g) {
		super.paint(offg);
		
		//kazuhiro kobayashi 10/2
		Graphics2D g2 = (Graphics2D)g;
		
		for(int i=0;i<this.commands.size();i++){
			
			//kazuhiro kobayashi 10/2
			this.commands.get(i).execute((Graphics2D)offg);
		}
		if(this.selectedRect != null){
			this.selectedRect.draw((Graphics2D)offg);
		}

		g2.drawImage(this.offImage,0,0,this);
		for(int i=0;i<this.pastedImages.size();i++){
			this.pastedImages.get(i).drawBounds(g2);
		}
	}
	
	
	public void addCommand(DrawCommand command){
		this.commands.add(command);
	}
	public void setMode(Mode mode){
		this.mode = mode;
	}
	public void mouseClicked(MouseEvent e) {
		this.mode.mouseClicked(e,this);
		this.repaint();
	}
	public void mouseEntered(MouseEvent e) {
		this.mode.mouseEntered(e,this);
		this.repaint();
	}
	public void mouseExited(MouseEvent e) {
		this.mode.mouseExited(e,this);
		this.repaint();
	}
	public void mousePressed(MouseEvent e) {
		this.mode.mousePressed(e,this);
		this.repaint();
	}
	public void mouseReleased(MouseEvent e) {
		this.mode.mouseReleased(e,this);
		this.repaint();
	}
	public void mouseDragged(MouseEvent e) {
		this.mode.mouseDragged(e,this);
		this.repaint();
	}
	public void mouseMoved(MouseEvent e) {
		this.mode.mouseMoved(e,this);
		this.repaint();
	}
	public void setSelection(SelectedRectangleView rect){
		this.selectedRect = rect;
	}
	
	public Image getImage() {
		return offImage;
	}

	public void cut() {
		/*
		 * int double֕ύX
		 */
		int x = this.selectedRect.getX();
	    int y = this.selectedRect.getY();
	    int width = this.selectedRect.getWidth();
	    int height = this.selectedRect.getHeight();
		this.selectedRect = null;
		this.clippedImage = new BufferedImage(width,height,BufferedImage.TYPE_INT_RGB);
		this.clipg = this.clippedImage.getGraphics();
		
		/*
		 * selection̒`ׂ+1 & -1
		 * ŏC
		 */
		CropImageFilter filter = new CropImageFilter(x+1,y+1,width-1,height-1);
		FilteredImageSource producer = new FilteredImageSource(this.offImage.getSource(),filter);
		Image img = Toolkit.getDefaultToolkit().createImage(producer);
		
		this.clipg.drawImage(img,0,0,width,height,this);
				
		this.clippedWidth = width;
		this.clippedHeight = height;
		this.commands.add(new CutCommand(x,y,width,height));
		
		this.repaint();
	}
	public void paste(){
		PasteImageCommand command = new PasteImageCommand(this.clippedImage,0,0,clippedWidth,this.clippedHeight,this);
		this.commands.add(command);
		this.pastedImages.add(command);
		this.repaint();
	}
	public boolean containsPastedImage(Point point){
		for(int i=0;i<this.pastedImages.size();i++){
			PasteImageCommand command = this.pastedImages.get(i);
			if(command.contains(point)){
				return true;
			}
		}
		return false;
	}
	public PasteImageCommand getPastedImage(Point point){
		for(int i=0;i<this.pastedImages.size();i++){
			PasteImageCommand command = this.pastedImages.get(i);
			if(command.contains(point)){
				return command;
			}
		}
		return null;
	}
}
