package jp.co.c_lis.ccl.maptracker.android.util;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.database.sqlite.SQLiteDatabase.CursorFactory;

public class DBManager extends SQLiteOpenHelper {

    // ＤＢのバージョン - ＤＢ構造を変更した場合は数字を繰り上げる
    public static final int DB_VERSION = 1;

    // ＤＢファイル名
    public static final String DB_FILE_NAME = "test.db";

    // 位置情報テーブル名
    public static final String DB_LOCATION_TABLE = "locations";

    public DBManager(Context context, String name, CursorFactory factory, int version) {
        super(context, name, factory, version);
    }

    @Override
    public void onCreate(SQLiteDatabase db) {
        // CREATE TABLE
        String sql = "CREATE TABLE " + DB_LOCATION_TABLE + " (" + "_id INTEGER PRIMARY KEY, "
                + "time LONG, " + "longitude FLOAT, " + "latitude FLOAT " + ")";
        db.execSQL(sql);
    }

    @Override
    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) { }
}
