/*
 * Copyright 2006-2007 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.seasar.codegen.impl;

import java.io.File;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Map;

import freemarker.template.Configuration;

public class NomalDiconOutputCodeImpl extends NomalDtoOutputCodeImpl {

    public NomalDiconOutputCodeImpl() {
        super.setDefaultDir("dicon");
        super.setTemplateFileName("dicon.ftl");
        super.setFileNameFtl("alldao.dicon");

    }

    public void generateCode(File baseDir, Map tableList) {
        Configuration cfg = getConfiguration();
        Map root = createRootObj(tableList);
        convetName(root);
        Writer out = createWriter(baseDir, root);
        processTemplate(cfg, root, out);
        destroyWriter(out);
    }

    @SuppressWarnings("unchecked")
    protected Map createRootObj(Map tableList) {
        Map<String, Object> root = createRootObj(tableList, "");
        ArrayList list = new ArrayList(tableList.values());
        root.put("tableList", list);
        return root;
    }

}
