${header}package ${package}.${defaultDir?lower_case};

<#assign importList=table.fieldImportDef>
<#list table.fieldImportDef as importName>
import ${importName};
</#list>
import java.util.Set;
import java.util.HashSet;

/**
 * ${table.tableName}テーブルに対応するDTOです。
 * @author S2Dao-CodeGen
 */
public class ${table.tableNameForDto?cap_first}Dto {

	/**
	 * ${table.tableName}テーブルに対応するTABLEアノテーションです。
	 */
	public static final String TABLE = "${table.tableName}";

	<#assign primarys=table.primaryKey>
	<#if primarys?size = 1 >
	<#assign primaryField=primarys?first>
	<#assign primaryName=primaryField.field.fieldNameForDto?uncap_first>
	/**
	 * 主キーに対応するIDアノテーションです。
	 */
	<#if identity = "sequence" >
	public static final String ${primaryName}_ID = "sequence, sequenceName=${primaryName}";
	</#if>
	<#if identity = "identity" >
	public static final String ${primaryName}_ID = "identity";
	</#if>
	<#if identity = "assigned" >
	public static final String ${primaryName}_ID = "assigned";
	</#if>
	</#if>
	<#list table.tableField as tableField>
	<#assign fieldName=tableField.fieldNameForDto?uncap_first>
	<#assign javaTypeName=tableField.dataType.langDataType.className>
	<#assign defaultVal=tableField.dataType.langDataType.defVal>
	private ${javaTypeName} ${fieldName}<#if defaultVal?length != 0> = ${defaultVal}</#if>;
	</#list>
	
	private Set modifiedPropertySet = new HashSet();

	<#list table.tableField as tableField>
	<#assign propertyName=tableField.fieldNameForDto?cap_first>
	<#assign fieldName=tableField.fieldNameForDto?uncap_first>
	<#assign javaTypeName=tableField.dataType.langDataType.className>
	<#assign fieldAttributeName=tableField.fieldAttributeName>
	/**
	 * ${fieldAttributeName}を返します。
	 * @return ${fieldAttributeName}
	 */
	public ${javaTypeName} get${propertyName}() {
		return ${fieldName};
	}

	/**
	 * ${fieldAttributeName}を設定します。
	 * @param ${fieldName} ${fieldAttributeName}
	 */
	public void set${propertyName}(${javaTypeName} ${fieldName}) {
		modifiedPropertySet.add("${fieldName}");
		this.${fieldName} = ${fieldName};
	}

	</#list>

	/**
	 * setterが呼ばれたプロパティのセットを返します。
	 * @return settterが呼ばれたプロパティのセット
	 */
	public Set getModifiedPropertyNames() {
		return this.modifiedPropertySet;
	}

	public String toString() {
		StringBuffer buff = new StringBuffer("[");
		<#list table.tableField as tableField>
		<#assign fieldName=tableField.fieldNameForDto?uncap_first>
		buff.append("/${fieldName}=").append(${fieldName});
		</#list>
		buff.append("]");
		return buff.toString();
	}
	
}
