import styled from 'styled-components';

const TabButton = styled.div`
  background-color: initial;
  border: none;
  border-radius: 2px;
  width: 26px;
  height: 26px;
  margin: 3px;
  padding: 3px;
  color: ${props => props.isActive ? 'black' : 'white'};
  background-image: url(${props => props.src});
  background-size: ${props => props.size};
  background-position: center;
  background-repeat: no-repeat;
  transition: 0.2s background-color;
  box-sizing: border-box;
  float: ${props => props.isRight ? 'right' : 'left'};
  &:hover {
    background-color: rgba(196, 196, 196, 0.4);
  }
`;

export default TabButton;