import React, { Component } from 'react';
import { render } from 'react-dom';
import Moment from 'react-moment';

import PropTypes from 'prop-types';
import { withStyles } from '@material-ui/core/styles';

import Link from '@material-ui/core/Link';
import Table from '@material-ui/core/Table';
import TableBody from '@material-ui/core/TableBody';
import TableCell from '@material-ui/core/TableCell';
import TableHead from '@material-ui/core/TableHead';
import TableRow from '@material-ui/core/TableRow';
import Paper from '@material-ui/core/Paper';

import NavigationBar from './Components/NavigationBar.jsx';

const styles = theme => ({
    root: {
        width: '100%',
        overflowX: 'auto',
    },
    table: {
        tableLayout: 'fixed',
        whiteSpace: 'nowrap'
    },
    tableIcon: {
        width: '4%',
        whiteSpace: 'nowrap',
    },
    tableTitle: {
        width: '56%',
        overflow: 'hidden',
        whiteSpace: 'nowrap',
        textOverflow: 'ellipsis'
    },
    tableUrl: {
        width: '40%',
        overflow: 'hidden',
        whiteSpace: 'nowrap',
        textOverflow: 'ellipsis'
    },
    tableDate: {
        width: 150,
        overflow: 'hidden',
        whiteSpace: 'nowrap',
        textOverflow: 'ellipsis'
    }
});

class Downloads extends Component {
    constructor(props) {
        super(props);

        this.state = {
            downloads: []
        };
    }

    componentDidMount = () => {
        window.getDownloads().then((data) => {
            this.setState({ downloads: data });
        });
    }

    render() {
        const { classes } = this.props;

        return (
            <NavigationBar title="ブックマーク">
                <Paper className={classes.root}>
                    <Table className={classes.table}>
                        <TableHead>
                            <TableRow>
                                <TableCell className={classes.tableIcon}></TableCell>
                                <TableCell className={classes.tableTitle}>タイトル</TableCell>
                                <TableCell className={classes.tableUrl}>URL</TableCell>
                                <TableCell className={classes.tableDate}>追加日時</TableCell>
                            </TableRow>
                        </TableHead>
                        <TableBody>
                            {this.state.downloads.map((item, i) => (
                                <TableRow key={i}>
                                    <TableCell className={classes.tableIcon}><img src={new URL(item.url).protocol === 'flast:' ? 'flast-file:///public.svg' : `http://www.google.com/s2/favicons?domain=${new URL(item.url).origin}`} style={{ width: 16, height: 16, verticalAlign: 'sub' }} /></TableCell>
                                    <TableCell component="th" scope="row" className={classes.tableTitle}><Link href={item.url} title={item.title} color="inherit">{item.title}</Link></TableCell>
                                    <TableCell title={item.url} className={classes.tableUrl}>{item.url}</TableCell>
                                    <TableCell className={classes.tableDate}><Moment format="YYYY/MM/DD HH:mm">{item.createdAt}</Moment></TableCell>
                                </TableRow>
                            ))}
                        </TableBody>
                    </Table>
                </Paper>
            </NavigationBar>
        );
    }
}

Downloads.propTypes = {
    classes: PropTypes.object.isRequired,
};

const Page = withStyles(styles)(Downloads);

render(
    <Page />,
    document.getElementById('app')
);