const pkg = require(`${__dirname}/../package.json`);
const protocolStr = 'flast';
const fileProtocolStr = `${protocolStr}-file`;

module.exports = {
    window: {
        titleBar: {
            tab: {
                close: 'Close this tab',
                new: 'Open a new tab'
            },
            buttons: {
                minimize: 'Minimize',
                maximize: {
                    maximize: 'Maximize',
                    restore: 'Restore (Shrink)'
                },
                close: 'Close'
            }
        },
        toolBar: {
            back: 'Go back to the previous page (Alt+Left)',
            forward: 'Go forward to the next page (Alt+Right)',
            reload: {
                reload: 'Reload (Ctrl+R)',
                stop: 'Stop loading'
            },
            home: 'Go to the home page',
            addressBar: {
                info: {
                    name: 'Information on this page',
                    clicked: {
                        internal: `Showing protected ${pkg.name} page`,
                        secure: 'The connection to this site is secure',
                        insecure: 'The connection to this site is not secure'
                    }
                },
                bookmark: {
                    add: 'Add to bookmark',
                    remove: 'Remove from bookmark',
                    clicked: {
                        add: 'Added to bookmark',
                        remove: 'Removed from bookmark',
                        addPrivate: 'Added to private bookmark',
                        removePrivate: 'Removed from private bookmarks'
                    }
                },
            },
            extensions: {
                adBlock: 'Blocked {replace} ads',
                feedback: 'Send Feedback'
            },
            menu: {
                name: 'Menu',
                menus: {
                    newTab: 'New tab',
                    newWindow: 'New window',
                    openPrivateWindow: 'Open Private window',
                    zoom: {
                        name: 'Zoom',
                        zoomIn: 'Zoom in',
                        zoomOut: 'Zoom out',
                        fullScreen: 'Full Screen'
                    },
                    history: 'History',
                    downloads: 'Downloads',
                    bookmarks: 'Bookmarks',
                    app: {
                        name: 'Application',
                        list: 'App list',
                        store: 'Flast Store',
                        install: 'Install {title}',
                        uninstall: 'Uninstall {title}',
                        run: 'Launch {title}'
                    },
                    print: 'Print',
                    find: 'Find on page',
                    settings: 'Settings',
                    help: 'Help',
                    close: 'Close'
                }
            }
        },
        view: {
            contextMenu: {
                link: {
                    newTab: 'Open link in new tab',
                    newWindow: 'Open link in new window',
                    openPrivateWindow: 'Open link in private window',
                    copy: 'Copy link'
                },
                image: {
                    newTab: 'Open image in new tab',
                    saveImage: 'Save image as',
                    copyImage: 'Copy image',
                    copyLink: 'Copy image link'
                },
                editable: {
                    undo: 'Undo',
                    redo: 'Redo',
                    cut: 'Cut',
                    copy: 'Copy',
                    paste: 'Paste',
                    selectAll: 'Select all'
                },
                selection: {
                    copy: 'Copy',
                    textSearch: 'Search {name} for "{text}" '
                },
                back: 'Back',
                forward: 'Forward',
                reload: {
                    reload: 'Reload',
                    stop: 'Stop loading'
                },
                floatingWindow: 'Floating Window (Beta)',
                savePage: 'Save page',
                print: 'Print',
                viewSource: 'View source',
                devTool: 'Developer Tool'
            }
        }
    }
}