const pkg = require(`${__dirname}/../package.json`);
const protocolStr = 'flast';
const fileProtocolStr = `${protocolStr}-file`;

module.exports = {
    window: {
        titleBar: {
            tab: {
                close: 'このタブを閉じる',
                new: '新しいタブを開く'
            },
            buttons: {
                minimize: '最小化',
                maximize: {
                    maximize: '最大化',
                    restore: '元に戻す (縮小)'
                },
                close: '閉じる'
            }
        },
        toolBar: {
            back: '前のページに戻る (Alt+Left)',
            forward: '次のページに進む (Alt+Right)',
            reload: {
                reload: '再読み込み (Ctrl+R)',
                stop: '読み込み中止'
            },
            home: 'ホームページに移動',
            addressBar: {
                info: {
                    name: 'このページの情報',
                    clicked: {
                        internal: `保護された ${pkg.name} ページを表示しています`,
                        secure: 'このサイトへの接続は保護されています',
                        insecure: 'このサイトへの接続は保護されていません'
                    }
                },
                bookmark: {
                    add: 'ブックマークに追加',
                    remove: 'ブックマークから削除',
                    clicked: {
                        add: 'ブックマークに追加しました',
                        remove: 'ブックマークから削除しました',
                        addPrivate: 'プライベート ブックマークに追加しました',
                        removePrivate: 'プライベート ブックマークから削除しました'
                    }
                },
            },
            extensions: {
                adBlock: '{replace}個の広告をブロックしました',
                feedback: 'フィードバックの送信'
            },
            menu: {
                name: 'メニュー',
                menus: {
                    newTab: '新しいタブ',
                    newWindow: '新しいウィンドウ',
                    openPrivateWindow: 'プライベート ウィンドウを開く',
                    zoom: {
                        name: 'ズーム',
                        zoomIn: '拡大',
                        zoomOut: '縮小',
                        fullScreen: '全画面表示'
                    },
                    history: '履歴',
                    downloads: 'ダウンロード',
                    bookmarks: 'ブックマーク',
                    app: {
                        name: 'アプリ',
                        list: 'アプリ リスト',
                        store: 'Flast Store',
                        install: '{title} をインストール',
                        uninstall: '{title} をアンインストール',
                        run: '{title} を起動'
                    },
                    print: '印刷',
                    find: '検索',
                    settings: '設定',
                    help: 'ヘルプ',
                    close: '閉じる'
                }
            }
        },
        view: {
            errorMessage: {
                UNDEFINED: {
                    title: '不明なエラーが発生しました', 
                    description: '不明なエラーが発生しました。エラーの説明等がまだ翻訳されていないときに表示されます。'
                },
                FILE_NOT_FOUND: {
                    title: 'ファイル・ディレクトリが見つかりませんでした',
                    description: '指定されたパスにファイル・ディレクトリが見つかりませんでした。\nパスが間違っていないかを確認してください。\n再試行するには、ページを再読み込みしてください。'
                },
                TIMED_OUT: {
                    title: 'タイムアウト',
                    description: 'タイムアウトで実行できませんでした。\n再試行するには、ページを再読み込みしてください。'
                },
                FILE_TOO_BIG: {
                    title: 'ファイルサイズが大きすぎます',
                    description: '指定されたパスのファイルが大きすぎます。\n再試行するには、ページを再読み込みしてください。'
                },
                ACCESS_DENIED: {
                    title: 'アクセスが拒否されました',
                    description: '指定されたパスへのアクセスが拒否されました。\nアクセス設定が正しいかを確認してください。\n再試行するには、ページを再読み込みしてください。'
                },
                NOT_IMPLEMENTED: {
                    title: 'この機能は実装されていません',
                    description: '実行しようとした機能は実装されていないため実行できませんでした。\nこのエラーはChromium側で発生することが多いのでFlast側では修正することができません。\nChromium側の更新をお待ちください。'
                },
                INSUFFICIENT_RESOURCES: {
                    title: '操作を完了するのに十分なリソースがありませんでした',
                    description: 'デバイスに負荷がかかっていないかを確かめてください。\n負荷がかかっている場合は負荷が軽減してから再試行してください。\n再試行するには、ページを再読み込みしてください。'
                },
                OUT_OF_MEMORY: {
                    title: 'メモリの割り当てに失敗しました',
                    description: 'メモリの割り当てに失敗しました。メモリが足りていない可能性があります。\nデバイスに負荷がかかっていないかを確かめてください。\n負荷がかかっている場合は負荷が軽減してから再試行してください。\n再試行するには、ページを再読み込みしてください。'
                },
                UPLOAD_FILE_CHANGED: {
                    title: 'ファイルのアップロードに失敗しました',
                    description: 'ファイルのアップロード時間が予想と異なるためファイルのアップロードができませんでした。\n再試行するには、ページを再読み込みしてください。'
                },
                FILE_EXISTS: {
                    title: 'ファイルがすでに存在しています',
                    description: 'ファイルがすでに存在しているため実行できませんでした。\n再試行するには、ページを再読み込みしてください。'
                },
                FILE_PATH_TOO_LONG: {
                    title: 'ファイル名・パスが長すぎます',
                    description: 'ファイル名・パスが長すぎます。\nファイル名・パスを短くしてから実行してください。\n再試行するには、ページを再読み込みしてください。'
                },
                FILE_NO_SPACE: {
                    title: 'ディスクに十分な空きがありません',
                    description: 'ディスクに十分な空きがありませんでした。\n使用していないファイルは削除するなどして、ディスクに十分な空きを作ってから実行してください。\n再試行するには、ページを再読み込みしてください。'
                },
                FILE_VIRUS_INFECTED: {
                    title: 'ファイルにウイルスがあります',
                    description: 'ファイルからウイルスが発見されました。\nそのファイルを実行することはできません。'
                }
            },
            contextMenu: {
                link: {
                    newTab: '新しいタブで開く',
                    newWindow: '新しいウィンドウで開く',
                    openPrivateWindow: 'プライベート ウィンドウで開く',
                    copy: 'リンクをコピー'
                },
                image: {
                    newTab: '新しいタブで画像を開く',
                    saveImage: '名前を付けて画像を保存',
                    copyImage: '画像をコピー',
                    copyLink: '画像アドレスをコピー'
                },
                editable: {
                    undo: '元に戻す',
                    redo: 'やり直す',
                    cut: '切り取り',
                    copy: 'コピー',
                    paste: '貼り付け',
                    selectAll: 'すべて選択'
                },
                selection: {
                    copy: 'コピー',
                    textSearch: '{name} で「{text}」を検索'
                },
                back: '戻る',
                forward: '進む',
                reload: {
                    reload: '再読み込み',
                    stop: '読み込み中止'
                },
                floatingWindow: 'Floating Window (Beta)',
                savePage: 'ページの保存',
                print: '印刷',
                viewSource: 'ページのソースを表示',
                devTool: 'デベロッパー ツール'
            }
        }
    },
    internalPages: {
        home: {},
        history: {
            title: '履歴',
            clear: {
                title: '閲覧履歴を削除'
            },
            table: {
                title: 'タイトル',
                url: 'URL',
                date: '閲覧日時'
            }
        },
        downloads: {
            title: 'ダウンロード',
            clear: {
                title: 'ダウンロード履歴を削除'
            },
            table: {
                title: 'タイトル',
                url: 'URL',
                status: 'ステータス',
                date: '開始日時'
            }
        },
        bookmarks: {
            title: 'ブックマーク',
            clear: {
                title: 'ブックマークを削除'
            },
            table: {
                title: 'タイトル',
                url: 'URL',
                date: '追加日時'
            }
        },
        settings: {
            title: '設定',
            sections: {
                design: {
                    name: 'デザイン',
                    controls: {
                        homeButton: 'ホームボタンを表示する',
                        bookMarkBar: 'ブックマーク バーを表示する',
                        darkTheme: 'ダーク テーマを使用する',
                        titleBar: 'カスタム タイトルバーを使用する',
                        details: 'ウィンドウの詳細設定'
                    }
                },
                homePage: {
                    title: 'ホームページ',
                    description: '現在、{replace} を使用しています。',
                    controls: {
                        homePage: 'ホーム ページ',
                        customPage: 'カスタムページ'
                    }
                }
            }
        }
    }
}