// Shell.h : CShell ̐錾

#ifndef __SHELL_H_
#define __SHELL_H_

#include "resource.h"       // C V{

/////////////////////////////////////////////////////////////////////////////
// CShell
class ATL_NO_VTABLE CShell : 
	public CComObjectRootEx<CComSingleThreadModel>,
	public CComCoClass<CShell, &CLSID_SeraphyScriptTools_Shell>,
	public ISupportErrorInfo,
	public IDispatchImpl<ISeraphyScriptTools_Shell, &IID_ISeraphyScriptTools_Shell, &LIBID_SERAPHYSCRIPTTOOLSLib>
{
public:
	CShell()
	{
		m_bConfirm = true;
		m_bSilent  = false;
		//
		m_pMainWindow = NULL;
		m_pMalloc  = NULL;
		SHGetMalloc(&m_pMalloc);
	}
	void FinalRelease()
	{
		if(m_pMalloc){
			m_pMalloc->Release();
			m_pMalloc = NULL;
		}
	}

	HWND GetMainWindow()
	{
		HWND hWnd = NULL;//m_hStaticMainWindow;
		if(m_pMainWindow){
			m_pMainWindow->get_HWND((long*)&hWnd);
		}
		return hWnd;
	}

DECLARE_REGISTRY_RESOURCEID(IDR_SHELL)

DECLARE_PROTECT_FINAL_CONSTRUCT()

BEGIN_COM_MAP(CShell)
	COM_INTERFACE_ENTRY(ISeraphyScriptTools_Shell)
	COM_INTERFACE_ENTRY(IDispatch)
	COM_INTERFACE_ENTRY(ISupportErrorInfo)
END_COM_MAP()

// ISupportsErrorInfo
	STDMETHOD(InterfaceSupportsErrorInfo)(REFIID riid);

// ISeraphyScriptTools_Shell
public:
	STDMETHOD(IsExist)(/*[in]*/VARIANT name,/*[out,retval]*/VARIANT* pVal);
	STDMETHOD(SetMainWindow)(/*[in]*/VARIANT varUnk);
	STDMETHOD(RecentDocs)(/*[in,optional]*/VARIANT text);
	STDMETHOD(EmptyRecycleBin)(/*[in,optional]*/VARIANT dir);
	BOOL m_bSilent;
	BOOL m_bConfirm;
	HRESULT FileOperationCore(UINT wFunc,FILEOP_FLAGS flag,VARIANT* from,VARIANT* to,VARIANT* pResult);
	LPSTR CreateDNStringFromVariant(VARIANT& from);
	STDMETHOD(get_Silent)(/*[out, retval]*/ BOOL *pVal);
	STDMETHOD(put_Silent)(/*[in]*/ BOOL newVal);
	STDMETHOD(get_Confirm)(/*[out, retval]*/ BOOL *pVal);
	STDMETHOD(put_Confirm)(/*[in]*/ BOOL newVal);
	STDMETHOD(Delete)(/*[in]*/VARIANT from,/*[out,retval]*/VARIANT* pVal);
	STDMETHOD(Move)(/*[in]*/VARIANT from,/*[in]*/VARIANT to,/*[out,retval]*/VARIANT* pVal);
	STDMETHOD(CopyRenameOnCollision)(/*[in]*/VARIANT from,/*[in]*/VARIANT to,/*[out,retval]*/VARIANT* pVal);
	STDMETHOD(Copy)(/*[in]*/VARIANT from,/*[in]*/VARIANT to,/*[out,retval]*/VARIANT* pVal);
	STDMETHOD(ParseName)(/*[in,optional]*/VARIANT text,/*[out,retval]*/VARIANT* pVal);
	STDMETHOD(GetDLLVersion)(/*[in]*/VARIANT text,/*[in,optional]*/VARIANT min,/*[out,retval]*/VARIANT* pVal);
	STDMETHOD(get_WindowsVersion)(/*[out, retval]*/ long *pVal);
	STDMETHOD(get_IsWindowNT)(/*[out, retval]*/ BOOL *pVal);
	STDMETHOD(GetSpecialFolderLocations)(/*[in]*/IUnknown* punkVal);
	STDMETHOD(ShellExecute)(/*[in]*/VARIANT path,/*[in,optional]*/VARIANT param,/*[in,optional]*/VARIANT initdir,/*[in,optional]*/VARIANT mode, /*[out,retval]*/VARIANT* punkVal);
protected:
	IMalloc* m_pMalloc;
	IOverlappedWindow* m_pMainWindow;
};

// Shell.h : CShellExecObj ̐錾


/////////////////////////////////////////////////////////////////////////////
// CShellExecObj
class ATL_NO_VTABLE CShellExecObj : 
	public CComObjectRootEx<CComSingleThreadModel>,
//	public CComCoClass<CShellExecObj, &CLSID_ShellExecObj>,
	public IDispatchImpl<IShellExecObj, &IID_IShellExecObj, &LIBID_SERAPHYSCRIPTTOOLSLib>
{
public:
	CShellExecObj()
	{
		m_hProcess = NULL;
	}
	void FinalRelease()
	{
		if(m_hProcess){
			CloseHandle(m_hProcess);
			m_hProcess = NULL;
		}
	}
DECLARE_REGISTRY_RESOURCEID(IDR_SHELLEXECOBJ)

DECLARE_PROTECT_FINAL_CONSTRUCT()

BEGIN_COM_MAP(CShellExecObj)
	COM_INTERFACE_ENTRY(IShellExecObj)
	COM_INTERFACE_ENTRY(IDispatch)
END_COM_MAP()

// IShellExecObj
public:
	STDMETHOD(get_ExitCode)(/*[out, retval]*/ long *pVal);
	STDMETHOD(Wait)(/*[in,optional]*/VARIANT tim,/*[out,retval]*/VARIANT* pVal);
	HANDLE m_hProcess;
};

// shell.h : CParseName ̐錾


/////////////////////////////////////////////////////////////////////////////
// CParseName
class ATL_NO_VTABLE CParseName : 
	public CComObjectRootEx<CComSingleThreadModel>,
	public CComCoClass<CParseName, &CLSID_ParseName>,
	public ISupportErrorInfo,
	public IDispatchImpl<ISeraphyScriptTool_ParseName, &IID_ISeraphyScriptTool_ParseName, &LIBID_SERAPHYSCRIPTTOOLSLib>
{
public:
	CParseName()
	{
	}

DECLARE_REGISTRY_RESOURCEID(IDR_PARSENAME)

DECLARE_PROTECT_FINAL_CONSTRUCT()

BEGIN_COM_MAP(CParseName)
	COM_INTERFACE_ENTRY(ISeraphyScriptTool_ParseName)
	COM_INTERFACE_ENTRY(IDispatch)
	COM_INTERFACE_ENTRY(ISupportErrorInfo)
END_COM_MAP()

// ISupportsErrorInfo
	STDMETHOD(InterfaceSupportsErrorInfo)(REFIID riid);

// ISeraphyScriptTool_ParseName
public:
	STDMETHOD(get_Directory)(/*[out, retval]*/ BSTR *pVal);
	STDMETHOD(get_Drive)(/*[out, retval]*/ BSTR *pVal);
	STDMETHOD(put_Drive)(/*[in]*/ BSTR newVal);
	STDMETHOD(get_Name)(/*[out, retval]*/ BSTR *pVal);
	STDMETHOD(put_Name)(/*[in]*/ BSTR newVal);
	STDMETHOD(get_Extention)(/*[out, retval]*/ BSTR *pVal);
	STDMETHOD(put_Extention)(/*[in]*/ BSTR newVal);
	STDMETHOD(get_FileName)(/*[out, retval]*/ BSTR *pVal);
	STDMETHOD(put_FileName)(/*[in]*/ BSTR newVal);
	STDMETHOD(get_PathName)(/*[out, retval]*/ BSTR *pVal);
	STDMETHOD(put_PathName)(/*[in]*/ BSTR newVal);
	_bstr_t m_bstr_path;
};

#endif //__SHELL_H_
