	
// OverlappedWindow.h : Declaration of the COverlappedWindow

#ifndef __OverlappedWindow_H_
#define __OverlappedWindow_H_

#include "resource.h"       // C V{
#include <atlctl.h>
#include <list>
#include <vector>
#include <map>
#include "seraphyscripttools.h"

#include "SeraphyScriptToolsCP.h"
#include "form.h"
#include "event.h"
#include "control.h"
#include "objectmap.h"


#include "draw.h"



///////////////////////////////////////////////////////////////////////
// hbvꂽt@C̕ێ
class dropfiledata
{
public:
	dropfiledata()
	{
	}
	~dropfiledata(){
		Clear();
	}
	void Clear()
	{
		list<LPSTR>::iterator p = m_lstPath.begin();
		while(p != m_lstPath.end()){
			delete (*p);
			p = m_lstPath.erase(p);
		}
	}
	void DropFiles(HDROP hDrop)
	{
		Clear();
		int count = ::DragQueryFile(hDrop,-1,NULL,0);
		int i;
		for(i=0;i<count;i++){
			DWORD sz = ::DragQueryFile(hDrop,i,NULL,0);
			LPSTR pBuf = new CHAR[sz+1];
			::DragQueryFile(hDrop,i,pBuf,MAX_PATH);
			m_lstPath.push_back(pBuf);
		}
	}
	void GetPathArray(VARIANT *pvarPathName)
	{
		if(m_lstPath.empty()){
			// ł
			pvarPathName->vt = VT_EMPTY;
			return;
		}
		SAFEARRAY* pArray = SafeArrayCreateVector(VT_VARIANT,0,m_lstPath.size());
		VARIANT* pvars;
		if(SafeArrayAccessData(pArray,(void**)&pvars) == S_OK){
			int i = 0;
			list<LPSTR>::iterator p = m_lstPath.begin();
			while(p != m_lstPath.end()){
				WCHAR wbuf[MAX_PATH];
				MultiByteToWideChar(GetACP(),0,*p,-1,wbuf,MAX_PATH);
				VariantInit(&pvars[i]);
				pvars[i].vt = VT_BSTR;
				pvars[i].bstrVal = SysAllocString(wbuf);
				p++;
				i++;
			}
			SafeArrayUnaccessData(pArray);
		}
		VariantInit(pvarPathName);
		pvarPathName->vt = VT_ARRAY | VT_VARIANT;
		pvarPathName->parray = pArray;
	}
protected:
	list<LPSTR> m_lstPath;
};

/////////////////////////////////////////////////////////////////////////////
// COverlappedWindow
class CreateOverlappedWindow
{
public:
	CreateOverlappedWindow()
	{
		style      = 0;
		exstyle    = 0;
		showMode   = 0;
		noclose    = false;
		frametype  = true;
		captionbar = true;
		systemmenu = true;
		minbox     = true;
		maxbox     = true;
		autoclose  = true;
		automessageloop = true;
		ZeroMemory(szClassName,MAX_PATH);
		posX = posY = width = height = 0;
	}
	DWORD GetStyle()
	{
		DWORD style = WS_CLIPCHILDREN | WS_OVERLAPPED;
		if(captionbar){ style |= WS_CAPTION;    }
		if(frametype ){ style |= WS_THICKFRAME; }
		if(systemmenu){ style |= WS_SYSMENU|WS_CAPTION;    }
		if(minbox    ){ style |= WS_MINIMIZEBOX|WS_SYSMENU|WS_CAPTION; }
		if(maxbox    ){ style |= WS_MAXIMIZEBOX|WS_SYSMENU|WS_CAPTION|WS_THICKFRAME; }
		return style;
	}
	inline void SetWindowPlacement(int x,int y,int w,int h)
	{
		posX   = x;
		posY   = y;
		width  = w;
		height = h;
	}
	inline void SetWindowClassName(LPCSTR name)
	{
		lstrcpy(szClassName,name);
	}
	CHAR szClassName[MAX_PATH];
	DWORD wndstyle;
	DWORD style;
	DWORD exstyle;
	int posX;
	int posY;
	int width;
	int height;
	int showMode;
	BOOL noclose;
	BOOL doublebuffer;
	BOOL frametype;
	BOOL captionbar;
	BOOL systemmenu;
	BOOL minbox;
	BOOL maxbox;
	BOOL automessageloop;
	BOOL autoclose;
};

class ATL_NO_VTABLE COverlappedWindow : 
	public CComObjectRootEx<CComSingleThreadModel>,
	public CStockPropImpl<COverlappedWindow, IOverlappedWindow, &IID_IOverlappedWindow, &LIBID_SERAPHYSCRIPTTOOLSLib>,
	public CComControl<COverlappedWindow>,
	public IPersistStreamInitImpl<COverlappedWindow>,
	public IOleControlImpl<COverlappedWindow>,
	public IOleObjectImpl<COverlappedWindow>,
	public IOleInPlaceActiveObjectImpl<COverlappedWindow>,
	public IViewObjectExImpl<COverlappedWindow>,
	public IOleInPlaceObjectWindowlessImpl<COverlappedWindow>,
	public ISupportErrorInfo,
	public IConnectionPointContainerImpl<COverlappedWindow>,
	public IPersistStorageImpl<COverlappedWindow>,
	public ISpecifyPropertyPagesImpl<COverlappedWindow>,
	public IQuickActivateImpl<COverlappedWindow>,
	public IDataObjectImpl<COverlappedWindow>,
	public IProvideClassInfo2Impl<&CLSID_OverlappedWindow, &DIID__IOverlappedWindowEvents, &LIBID_SERAPHYSCRIPTTOOLSLib>,
	public IPropertyNotifySinkCP<COverlappedWindow>,
	public CComCoClass<COverlappedWindow, &CLSID_OverlappedWindow>,
	public CProxy_IOverlappedWindowEvents< COverlappedWindow >
{
public:
	COverlappedWindow();

DECLARE_GET_CONTROLLING_UNKNOWN()
DECLARE_REGISTRY_RESOURCEID(IDR_OVERLAPPEDWINDOW)

DECLARE_PROTECT_FINAL_CONSTRUCT()

BEGIN_COM_MAP(COverlappedWindow)
	COM_INTERFACE_ENTRY(IOverlappedWindow)
	COM_INTERFACE_ENTRY(IDispatch)
	COM_INTERFACE_ENTRY(IViewObjectEx)
	COM_INTERFACE_ENTRY(IViewObject2)
	COM_INTERFACE_ENTRY(IViewObject)
	COM_INTERFACE_ENTRY(IOleInPlaceObjectWindowless)
	COM_INTERFACE_ENTRY(IOleInPlaceObject)
	COM_INTERFACE_ENTRY2(IOleWindow, IOleInPlaceObjectWindowless)
	COM_INTERFACE_ENTRY(IOleInPlaceActiveObject)
	COM_INTERFACE_ENTRY(IOleControl)
	COM_INTERFACE_ENTRY(IOleObject)
	COM_INTERFACE_ENTRY(IPersistStreamInit)
	COM_INTERFACE_ENTRY2(IPersist, IPersistStreamInit)
	COM_INTERFACE_ENTRY(ISupportErrorInfo)
	COM_INTERFACE_ENTRY(IConnectionPointContainer)
	COM_INTERFACE_ENTRY(ISpecifyPropertyPages)
	COM_INTERFACE_ENTRY(IQuickActivate)
	COM_INTERFACE_ENTRY(IPersistStorage)
	COM_INTERFACE_ENTRY(IDataObject)
	COM_INTERFACE_ENTRY(IProvideClassInfo)
	COM_INTERFACE_ENTRY(IProvideClassInfo2)
	COM_INTERFACE_ENTRY_AGGREGATE(IID_IMarshal, m_pUnkMarshaler.p)
	COM_INTERFACE_ENTRY_IMPL(IConnectionPointContainer)
END_COM_MAP()

BEGIN_PROP_MAP(COverlappedWindow)
	PROP_DATA_ENTRY("_cx", m_sizeExtent.cx, VT_UI4)
	PROP_DATA_ENTRY("_cy", m_sizeExtent.cy, VT_UI4)
	PROP_ENTRY("Caption", DISPID_CAPTION, CLSID_NULL)
	// Example entries
	// PROP_ENTRY("Property Description", dispid, clsid)
	// PROP_PAGE(CLSID_StockColorPage)
END_PROP_MAP()

BEGIN_CONNECTION_POINT_MAP(COverlappedWindow)
	CONNECTION_POINT_ENTRY(IID_IPropertyNotifySink)
	CONNECTION_POINT_ENTRY(DIID__IOverlappedWindowEvents)
END_CONNECTION_POINT_MAP()

BEGIN_MSG_MAP(COverlappedWindow)
	CHAIN_MSG_MAP(CComControl<COverlappedWindow>)
	DEFAULT_REFLECTION_HANDLER()
END_MSG_MAP()
// Handler prototypes:
//  LRESULT MessageHandler(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled);
//  LRESULT CommandHandler(WORD wNotifyCode, WORD wID, HWND hWndCtl, BOOL& bHandled);
//  LRESULT NotifyHandler(int idCtrl, LPNMHDR pnmh, BOOL& bHandled);

	HRESULT FinalConstruct();
	void FinalRelease();
	
	CComPtr<IUnknown> m_pUnkMarshaler;

// ISupportsErrorInfo
	STDMETHOD(InterfaceSupportsErrorInfo)(REFIID riid)
	{
		static const IID* arr[] = 
		{
			&IID_IOverlappedWindow,
		};
		for (int i=0; i<sizeof(arr)/sizeof(arr[0]); i++)
		{
			if (IsEqualGUID(*arr[i], riid))
				return S_OK;
		}
		return S_FALSE;
	}

// IViewObjectEx
	DECLARE_VIEW_STATUS(VIEWSTATUS_SOLIDBKGND | VIEWSTATUS_OPAQUE)

// IOverlappedWindow
public:
	STDMETHOD(GetClipboardText)(/*[out]*/VARIANT* pVarText);
	STDMETHOD(SetClipboardText)(/*[in]*/BSTR text);
	STDMETHOD(get_DefaultAction)(/*[out, retval]*/ BOOL *pVal);
	STDMETHOD(put_DefaultAction)(/*[in]*/ BOOL newVal);
	STDMETHOD(get_AutoReleaseClassObject)(/*[out, retval]*/ BOOL *pVal);
	STDMETHOD(put_AutoReleaseClassObject)(/*[in]*/ BOOL newVal);
	STDMETHOD(get_innerHeight)(/*[out, retval]*/ double *pVal);
	STDMETHOD(get_innerWidth)(/*[out, retval]*/ double *pVal);
	STDMETHOD(get_ClientHeight)(/*[out, retval]*/ long *pVal);
	STDMETHOD(get_ClientWidth)(/*[out, retval]*/ long *pVal);
	void ClassObjectInvoke(LPCWSTR handler);
	STDMETHOD(get_ClassObject)(/*[out, retval]*/ VARIANT *pVal);
	STDMETHOD(put_ClassObject)(/*[in]*/ VARIANT newVal);
	STDMETHOD(CenterWindow)();
	STDMETHOD(LoadIcon)(/*[in]*/VARIANT text);
	STDMETHOD(get_WaitCursor)(/*[out, retval]*/ short *pVal);
	STDMETHOD(put_WaitCursor)(/*[in]*/ short newVal);
	STDMETHOD(get_ExitCode)(/*[out, retval]*/ short *pVal);
	STDMETHOD(put_ExitCode)(/*[in]*/ short newVal);
	STDMETHOD(get_Object)(/*[in,optional]*/VARIANT idx, /*[out, retval]*/ VARIANT *pVal);
	void MoveNextOverlapped();
	void CreateWindowList(list<HWND>& lstWnd,BOOL bSearchRoot);
	STDMETHOD(get_AutoClose)(/*[out, retval]*/ BOOL *pVal);
	STDMETHOD(put_AutoClose)(/*[in]*/ BOOL newVal);
	STDMETHOD(DoModal)(/*[out,retval]*/VARIANT* retcode);
	STDMETHOD(get_AutoMessageLoop)(/*[out, retval]*/ BOOL *pVal);
	STDMETHOD(put_AutoMessageLoop)(/*[in]*/ BOOL newVal);
	static DWORD MessageLoop(DWORD sleeptim,int count,HWND* hWnd,HANDLE* hEvent);
	void SetWaitParam(int* count,HWND* phWnd,HANDLE* phWaitHandle);
	HANDLE GetEventHandle();
	void SetParent(HWND hParent);
	STDMETHOD(CreateChild)(/*[out,retval]*/VARIANT* pvarUnk);
	STDMETHOD(SetWindowStyle)(/*[in]*/VARIANT frametype,/*[in,optional]*/VARIANT caption_system,/*[in,optional]*/VARIANT maxmin,/*[out,retval]*/VARIANT* pvarUnk);
	STDMETHOD(SetPlacement)(/*[in]*/VARIANT x,/*[in]*/VARIANT y,/*[in,optional]*/VARIANT w,/*[in,optional]*/VARIANT h,/*[out,retval]*/VARIANT* pvarUnk);
	STDMETHOD(Refresh)();
	STDMETHOD(get_WindowClassName)(/*[out, retval]*/ BSTR *pVal);
	STDMETHOD(get_Exstyle)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_Exstyle)(/*[in]*/ long newVal);
	STDMETHOD(get_Style)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_Style)(/*[in]*/ long newVal);
	STDMETHOD(Close)();
	STDMETHOD(Draw)();
	STDMETHOD(Open)(/*[in]*/VARIANT caption,/*[out,retval]*/VARIANT* pvarUnk);
	STDMETHOD(DoEvent)(/*[out,retval]*/VARIANT* varResult);
	STDMETHOD(get_IsEventEmpty)(/*[out, retval]*/ BOOL *pVal);
	STDMETHOD(SetTimer)(/*[in]*/VARIANT tim,/*[out,retval]*/BOOL* pVal);

	HRESULT OnDraw(ATL_DRAWINFO& di)
	{
		RECT& rc = *(RECT*)di.prcBounds;
		Rectangle(di.hdcDraw, rc.left, rc.top, rc.right, rc.bottom);

		SetTextAlign(di.hdcDraw, TA_CENTER|TA_BASELINE);
		LPCTSTR pszText = _T("SeraphyScriptTools.OverlappedWindow");
		TextOut(di.hdcDraw, 
			(rc.left + rc.right) / 2, 
			(rc.top + rc.bottom) / 2, 
			pszText, 
			lstrlen(pszText));

		return S_OK;
	}

	STDMETHOD(get_Caption)(/*[out, retval]*/ BSTR *pVal);
	STDMETHOD(put_Caption)(/*[in]*/ BSTR newVal);
	STDMETHOD(get_backColor)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_backColor)(/*[in]*/ long newVal);
	STDMETHOD(get_Form)(/*[out, retval]*/ VARIANT *pVal);
	STDMETHOD(get_Quit)(/*[out, retval]*/ BOOL *pVal);
	STDMETHOD(put_Quit)(/*[in]*/ BOOL newVal);
	STDMETHOD(get_DropFiles)(/*[out, retval]*/ VARIANT *pVal);
	STDMETHOD(get_Event)(/*[out, retval]*/ VARIANT *pVal);
	STDMETHOD(get_Canvas)(/*[out, retval]*/ VARIANT *pVal);
	STDMETHOD(get_CreateNoCloseWindow)(/*[out, retval]*/ BOOL *pVal);
	STDMETHOD(put_CreateNoCloseWindow)(/*[in]*/ BOOL newVal);
	STDMETHOD(EnableMenu)(/*[in]*/VARIANT cmd,/*[in]*/VARIANT mode);
	STDMETHOD(CheckMenu)(/*[in]*/VARIANT cmd,/*[in]*/VARIANT mode);
	STDMETHOD(GetSysColor)(/*[in]*/VARIANT typ,/*[out,retval]*/VARIANT* col);
	STDMETHOD(get_HWND)(/*[out, retval]*/ long *pVal);
	STDMETHOD(TrackPopupMenu)(/*[in]*/VARIANT text,/*[in,optional]*/VARIANT cmd,/*[out,retval]*/VARIANT* pRet);
	STDMETHOD(SetMenu)(/*[in]*/VARIANT fmt);
	STDMETHOD(WaitEvent)(/*[in,optional]*/VARIANT varTim,/*[out,retval]*/BOOL* pRet);
	STDMETHOD(get_Visible)(/*[out, retval]*/ BOOL *pVal);
	STDMETHOD(put_Visible)(/*[in]*/ BOOL newVal);
	STDMETHOD(get_Zoomed)(/*[out, retval]*/ BOOL *pVal);
	STDMETHOD(put_Zoomed)(/*[in]*/ BOOL newVal);
	STDMETHOD(get_Iconic)(/*[out, retval]*/ BOOL *pVal);
	STDMETHOD(put_Iconic)(/*[in]*/ BOOL newVal);
	STDMETHOD(get_Enable)(/*[out, retval]*/ BOOL *pVal);
	STDMETHOD(put_Enable)(/*[in]*/ BOOL newVal);
	STDMETHOD(SetFocus)();
	STDMETHOD(SetForegroundWindow)();
	STDMETHOD(get_AcceptFiles)(/*[out, retval]*/ BOOL *pVal);
	STDMETHOD(put_AcceptFiles)(/*[in]*/ BOOL newVal);
	STDMETHOD(get_Height)(/*[out, retval]*/ short *pVal);
	STDMETHOD(put_Height)(/*[in]*/ short newVal);
	STDMETHOD(get_Width)(/*[out, retval]*/ short *pVal);
	STDMETHOD(put_Width)(/*[in]*/ short newVal);
	STDMETHOD(get_PosY)(/*[out, retval]*/ short *pVal);
	STDMETHOD(put_PosY)(/*[in]*/ short newVal);
	STDMETHOD(get_PosX)(/*[out, retval]*/ short *pVal);
	STDMETHOD(put_PosX)(/*[in]*/ short newVal);
	STDMETHOD(get_TopMost)(/*[out, retval]*/ BOOL *pVal);
	STDMETHOD(put_TopMost)(/*[in]*/ BOOL newVal);
	STDMETHOD(get_DoubleBuffer)(/*[out, retval]*/ BOOL *pVal);
	STDMETHOD(put_DoubleBuffer)(/*[in]*/ BOOL newVal);
	CComBSTR m_bstrCaption;
protected:
	HWND SafeCreateWnd();
	CreateOverlappedWindow windowParam;
	CComObject<CCanvas>* m_pCanvas;
	CComObject<CForm>* m_pForm;
	CComObject<CEvent>* m_pEvent;
	CComObject<CObjectMap>* m_pObject;
	list<CComObject<CEvent>*> m_lstEvent;
	list<CComObject<COverlappedWindow>*> m_lstChild;
	vector<CComVariant> m_vectorObject;
	dropfiledata m_dropfiles;
	CRITICAL_SECTION m_objEventDataProtection;
	BOOL m_bAutoReleaseClassObject;
	BOOL m_bDefaultAction;
protected:
	static LRESULT  CALLBACK WindowProc(HWND hwnd,UINT uMsg,WPARAM wParam,LPARAM lParam);
	void AddEvent(int message,WPARAM wParam,LPARAM lParam);
	void AddEventSingle(int message,WPARAM wParam,LPARAM lParam);
	void CreateThisInterface(VARIANT* pvarUnk);
	void SetTitle();
protected:
	IDispatch* m_pClassDisp;
	int m_dWaitCursor;
	BOOL m_bQuit;
	int m_dModalExitCode;
	DWORD m_dwBackColor;
	int m_dCaptureMode;
	HWND m_hLastFocusControl;
	HBRUSH m_hBkBrush;
	HMENU m_hMenu;
	HANDLE m_hWaitEvent;
	HWND m_hPopupWnd;
	HWND m_hParentWnd;
	HICON m_hIcon;
	map<int,_bstr_t> m_cMenuMap;
};

#endif //__OverlappedWindow_H_
