// ObjectVector.cpp : CObjectVector ̃Cve[V
#include "stdafx.h"
#include "SeraphyScriptTools.h"
#include "ObjectVector.h"
#include "generic.h"

/////////////////////////////////////////////////////////////////////////////
// CObjectVector

STDMETHODIMP CObjectVector::InterfaceSupportsErrorInfo(REFIID riid)
{
	static const IID* arr[] = 
	{
		&IID_IObjectVector
	};
	for (int i=0; i < sizeof(arr) / sizeof(arr[0]); i++)
	{
		if (IsEqualGUID(*arr[i],riid))
			return S_OK;
	}
	return S_FALSE;
}

STDMETHODIMP CObjectVector::CreateVector(IUnknown **punkVal)
{
	*punkVal = NULL;
	CComObject<CObjectVector>* pVct = NULL;
	if(pVct->CreateInstance(&pVct) == S_OK){
		pVct->QueryInterface(IID_IUnknown,(void**)punkVal);
	}
	return S_OK;
}

STDMETHODIMP CObjectVector::Duplicate(VARIANT idx,VARIANT count,IUnknown **punkVal)
{
	*punkVal = NULL;
	CComObject<CObjectVector>* pVct = NULL;
	if(pVct->CreateInstance(&pVct) == S_OK){
		pVct->QueryInterface(IID_IUnknown,(void**)punkVal);
	}
	if(!m_vctVariant.empty()){
		// wʒuw萔̕
		CComVariant varIdx,varCount;
		long nIdx = 0;
		if(varIdx.ChangeType(VT_I4,&idx) == S_OK){
			nIdx = varIdx.lVal;
		}
		long nCount = -1; // 0w肷Ɩ܂ł̃JEgvZ
		if(varCount.ChangeType(VT_I4,&count) == S_OK){
			nCount = varCount.lVal;
		}
		long mx = m_vctVariant.size();
		if(nCount < 0 || nIdx + nCount >= mx){
			nCount = mx - nIdx;
		}
		if(nIdx < 0){
			nIdx = 0;
		}
		if(nIdx < mx){
			long i;
			for(i=0 ; i<nCount ; i++){
				VARIANT tmp;
				::VariantInit(&tmp);
				::VariantCopy(&tmp,&m_vctVariant.at(nIdx + i));
				pVct->m_vctVariant.push_back(tmp);
			}
		}
	}
	return S_OK;
}

STDMETHODIMP CObjectVector::Clear()
{
	//VARIANT̃NAƘAzz̉
	VariantVector::iterator p = m_vctVariant.begin();
	while(p != m_vctVariant.end()){
		::VariantClear(&*p);
		p++;
	}
	m_vctVariant.clear();
	return S_OK;
}

STDMETHODIMP CObjectVector::Erase(VARIANT idx, VARIANT count)
{
	// wʒuw萔̍폜
	CComVariant varIdx,varCount;
	long nIdx = 0;
	if(varIdx.ChangeType(VT_I4,&idx) == S_OK){
		nIdx = varIdx.lVal;
	}
	long nCount = 1;
	if(varCount.ChangeType(VT_I4,&count) == S_OK){
		nCount = varCount.lVal;
	}
	long mx = m_vctVariant.size();
	if(nCount < 0 || nIdx + nCount >= mx){
		nCount = mx - nIdx;
	}
	if(nIdx < 0 || nIdx >= mx || nCount < 0 ){
		return DISP_E_BADINDEX;
	}
	m_vctVariant.erase(m_vctVariant.begin() + nIdx,m_vctVariant.begin() + nIdx + nCount);
	return S_OK;
}

STDMETHODIMP CObjectVector::Push(VARIANT newVal)
{
	// ɒǉ
	VARIANT tmp;
	::VariantInit(&tmp);
	::VariantCopy(&tmp,&newVal);
	m_vctVariant.push_back(tmp);
	return S_OK;
}

STDMETHODIMP CObjectVector::Pop(VARIANT *pVal)
{
	// o
	::VariantInit(pVal);
	if(!m_vctVariant.empty()){
		long mx = m_vctVariant.size();
		::VariantInit(pVal);
		::VariantCopy(pVal,&m_vctVariant.at(mx-1));
		m_vctVariant.pop_back();
	}
	return S_OK;
}

STDMETHODIMP CObjectVector::Insert(VARIANT idx, VARIANT newVal)
{
	// wʒuɑ}
	CComVariant varIdx;
	long nIdx = 0;
	if(varIdx.ChangeType(VT_I4,&idx) == S_OK){
		nIdx = varIdx.lVal;
	}
	long mx = m_vctVariant.size();
	if(nIdx < 0 || nIdx >= mx){
		return DISP_E_BADINDEX;
	}
	VARIANT tmp;
	::VariantInit(&tmp);
	::VariantCopy(&tmp,&newVal); 
	m_vctVariant.insert(m_vctVariant.begin() + nIdx,tmp);
	return S_OK;
}

STDMETHODIMP CObjectVector::get_Value(VARIANT idx, VARIANT *pVal)
{
	::VariantInit(pVal);
	long nIdx = 0;
	CComVariant varIdx;
	if(varIdx.ChangeType(VT_I4,&idx) == S_OK){
		nIdx = varIdx.lVal;
	}
	if(nIdx < 0){
		return DISP_E_BADINDEX;
	}
	long mx = m_vctVariant.size();
	if(nIdx < mx){
		// xN^[͈͓̔Ȃl擾
		::VariantCopy(pVal,&m_vctVariant.at(nIdx));
	}
	return S_OK;
}

STDMETHODIMP CObjectVector::put_Value(VARIANT idx, VARIANT newVal)
{
	long nIdx = 0;
	CComVariant varIdx;
	if(varIdx.ChangeType(VT_I4,&idx) == S_OK){
		nIdx = varIdx.lVal;
	}
	if(nIdx < 0){
		return DISP_E_BADINDEX;
	}
	long mx = m_vctVariant.size();
	if(nIdx >= mx){
		// xN^[͈̔͂𒴂ĂΊgAꂽVARIANTŖ߂
		VARIANT tmp;
		::VariantInit(&tmp);
		while(mx <= nIdx){
			m_vctVariant.push_back(tmp);
			mx++;
		}
	}
	// xN^[͈͓̔ȂlĐݒ肷
	::VariantClear(&m_vctVariant.at(nIdx));
	::VariantCopy(&m_vctVariant.at(nIdx),&newVal);
	return S_OK;
}

STDMETHODIMP CObjectVector::get_Count(long *pVal)
{
	*pVal = m_vctVariant.size();
	return S_OK;
}

STDMETHODIMP CObjectVector::get__NewEnum(IUnknown **pVal)
{
	typedef CComEnumDynaVARIANT<CObjectVector> CComEnumDynaVector;
	CComObject<CComEnumDynaVector>* pDyna = NULL;
	if(pDyna->CreateInstance(&pDyna) == S_OK){
		pDyna->Init(this,0);
		pDyna->QueryInterface(IID_IEnumVARIANT,(void**)pVal);
	}
	return S_OK;
}

STDMETHODIMP CObjectVector::Merge(VARIANT unkVal)
{
	HRESULT ret = DISP_E_TYPEMISMATCH;
	CComVariant varUnk;
	if(varUnk.ChangeType(VT_UNKNOWN,&unkVal) == S_OK){
		// C^[tFCX̏ꍇ
		IObjectVector* pVect = NULL;
		if(varUnk.punkVal->QueryInterface(IID_IObjectVector,(void**)&pVect) != S_OK){
			// wÕC^[tFCXł
			return DISP_E_TYPEMISMATCH;
		}
		long mx;
		pVect->get_Count(&mx);
		long i;
		for(i=0;i<mx;i++){
			CComVariant idx((long)i);
			VARIANT ret;
			::VariantInit(&ret);
			pVect->get_Value(idx,&ret);
			m_vctVariant.push_back(ret);
		}
		pVect->Release();
		ret = S_OK;
	}
	else{
		VARTYPE vt = VT_EMPTY;
		SAFEARRAY* pArray = GetArrayFromVariant(unkVal,&vt);
		if(pArray && vt == VT_VARIANT){
			long lb = 0;
			long ub = 0;
			int dm = SafeArrayGetDim(pArray);
			SafeArrayGetLBound(pArray,1,&lb); // ̓Y
			SafeArrayGetUBound(pArray,1,&ub);
			if(dm == 1 && lb == 0 && vt == VT_VARIANT){
				// 1zŁA0x[X̃oAgzł
				int cnt;
				long dim[1];
				for(cnt = 0 ; cnt <= ub ; cnt++){
					// VARIANT̔zł
					VARIANT tmp;
					::VariantInit(&tmp);
					dim[0] = cnt;
					SafeArrayGetElement(pArray,dim,&tmp);
					m_vctVariant.push_back(tmp);
				}//next(z̃[v)
				ret = S_OK;
			}
		}
	}
	return ret;
}


STDMETHODIMP CObjectVector::MakeArray(VARIANT *pVal)
{
	long mx = m_vctVariant.size();
	SAFEARRAY* pArray = SafeArrayCreateVector(VT_VARIANT,0,mx);
	VARIANT* pvars;
	if(SafeArrayAccessData(pArray,(void**)&pvars) == S_OK){
		long cnt = 0;
		for(cnt = 0; cnt < mx ; cnt++){
			VariantInit(&pvars[cnt]);
			VariantCopy(&pvars[cnt],&m_vctVariant.at(cnt));
		}
		SafeArrayUnaccessData(pArray);
	}
	pArray->fFeatures |= FADF_HAVEVARTYPE;
	pVal->vt     = VT_ARRAY | VT_VARIANT;
	pVal->parray = pArray;
	return S_OK;
}
