#include "stdafx.h"
#include "SeraphyScriptTools.h"
#include "generic.h"

SAFEARRAY* GetArrayFromVariant(VARIANT& var, VARTYPE* pVt)
{
	// ^̏
	if (pVt) {
		*pVt = VT_ERROR;
	}
	VARIANT* pParseVariant = &var;
	SAFEARRAY* pArray = NULL;
	if (!(var.vt & VT_ARRAY) && (var.vt & (VT_BYREF | VT_VARIANT))) {
		// zł͂ȂāAoAg̎QƓnł΁Ã|C^ɉ͂킹
		pParseVariant = var.pvarVal;
	}
	if (!(pParseVariant->vt & VT_ARRAY)) {
		// zȊOȂI
		return NULL;
	}
	// zł
	if (pParseVariant->vt & VT_BYREF) {
		// z̎QƓnł
		pArray = *pParseVariant->pparray;
	}
	else {
		// z񂻂̂̂ł
		pArray = pParseVariant->parray;
	}
	// ^̎o (SafeArrayɂ͌^͕K{ł͂Ȃ)
	if (pVt) {
		*pVt = (pParseVariant->vt & VT_TYPEMASK);
	}
	return pArray;
}

/**
 * VARIANT^ϐ(ByRef^)Ăꍇ́A
 * ꎩglƂȂ悤ByVal^ɋϊăRs[.
 * (ByValłΒPɃRs[.)
 */
HRESULT VariantCopyByVal(VARIANT *pDestVal, const VARIANT *pSrcVal)
{
	if (!pDestVal || !pSrcVal) {
		return E_POINTER;
	}
	ATLASSERT(pDestVal != pSrcVal);

	VariantInit(pDestVal);

	if (pSrcVal->vt & VT_BYREF) {
		// ByRef̏ꍇByValɕϊ.
		VARTYPE vt = pSrcVal->vt & ~VT_BYREF;

		if (vt == VT_VARIANT) {
			// Variant̃|C^̏ꍇ́Ã|C^Rs[̂
			return VariantCopy(pDestVal, pSrcVal->pvarVal);
		}
		else {
			// ^ϊgByRefO
			return VariantChangeType(pDestVal, pSrcVal, 0, vt);
		}
	}

	// ByVal̏ꍇ̓Rs[̂
	return VariantCopy(pDestVal, pSrcVal);
}
