// Instance.h : Declaration of the CInstance

#pragma once

#include "resource.h"       // C V{
#include <atlctl.h>
#include <list>
#include "OverlappedWindow.h"
#include "commdialog.h"

/////////////////////////////////////////////////////////////////////////////
// CInstance
class ATL_NO_VTABLE CInstance :
	public CComObjectRootEx<CComSingleThreadModel>,
	public CComCoClass<CInstance, &CLSID_SeraphyScriptTools_Instance>,
	public ISupportErrorInfoImpl<&IID_ISeraphyScriptTools_Instance>,
	public CComControl<CInstance>,
	public CStockPropImpl<CInstance, ISeraphyScriptTools_Instance, &IID_ISeraphyScriptTools_Instance, &LIBID_SERAPHYSCRIPTTOOLSLib>,
	public IPersistStreamInitImpl<CInstance>,
	public IOleControlImpl<CInstance>,
	public IOleObjectImpl<CInstance>,
	public IOleInPlaceActiveObjectImpl<CInstance>,
	public IViewObjectExImpl<CInstance>,
	public IOleInPlaceObjectWindowlessImpl<CInstance>,
	public IConnectionPointContainerImpl<CInstance>,
	public IPersistStorageImpl<CInstance>,
	public ISpecifyPropertyPagesImpl<CInstance>,
	public IQuickActivateImpl<CInstance>,
	public IDataObjectImpl<CInstance>,
	public IProvideClassInfo2Impl<&CLSID_SeraphyScriptTools_Instance, &DIID__ISeraphyScriptTools_InstanceEvents, &LIBID_SERAPHYSCRIPTTOOLSLib>,
	public IPropertyNotifySinkCP<CInstance>
{
public:
	HRESULT FinalConstruct();
	void FinalRelease();

	DECLARE_REGISTRY_RESOURCEID(IDR_INSTANCE)

	DECLARE_PROTECT_FINAL_CONSTRUCT()

	BEGIN_COM_MAP(CInstance)
		COM_INTERFACE_ENTRY(ISeraphyScriptTools_Instance)
		COM_INTERFACE_ENTRY(IDispatch)
		COM_INTERFACE_ENTRY(IViewObjectEx)
		COM_INTERFACE_ENTRY(IViewObject2)
		COM_INTERFACE_ENTRY(IViewObject)
		COM_INTERFACE_ENTRY(IOleInPlaceObjectWindowless)
		COM_INTERFACE_ENTRY(IOleInPlaceObject)
		COM_INTERFACE_ENTRY2(IOleWindow, IOleInPlaceObjectWindowless)
		COM_INTERFACE_ENTRY(IOleInPlaceActiveObject)
		COM_INTERFACE_ENTRY(IOleControl)
		COM_INTERFACE_ENTRY(IOleObject)
		COM_INTERFACE_ENTRY(IPersistStreamInit)
		COM_INTERFACE_ENTRY2(IPersist, IPersistStreamInit)
		COM_INTERFACE_ENTRY(ISupportErrorInfo)
		COM_INTERFACE_ENTRY(IConnectionPointContainer)
		COM_INTERFACE_ENTRY(ISpecifyPropertyPages)
		COM_INTERFACE_ENTRY(IQuickActivate)
		COM_INTERFACE_ENTRY(IPersistStorage)
		COM_INTERFACE_ENTRY(IDataObject)
		COM_INTERFACE_ENTRY(IProvideClassInfo)
		COM_INTERFACE_ENTRY(IProvideClassInfo2)
	END_COM_MAP()

	BEGIN_PROP_MAP(CInstance)
		PROP_DATA_ENTRY("_cx", m_sizeExtent.cx, VT_UI4)
		PROP_DATA_ENTRY("_cy", m_sizeExtent.cy, VT_UI4)
		PROP_ENTRY("Caption", DISPID_CAPTION, CLSID_NULL)
		// Example entries
		// PROP_ENTRY("Property Description", dispid, clsid)
		// PROP_PAGE(CLSID_StockColorPage)
	END_PROP_MAP()

	BEGIN_CONNECTION_POINT_MAP(CInstance)
		CONNECTION_POINT_ENTRY(IID_IPropertyNotifySink)
	END_CONNECTION_POINT_MAP()

	BEGIN_MSG_MAP(CInstance)
		CHAIN_MSG_MAP(CComControl<CInstance>)
		DEFAULT_REFLECTION_HANDLER()
	END_MSG_MAP()
	// Handler prototypes:
	//  LRESULT MessageHandler(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled);
	//  LRESULT CommandHandler(WORD wNotifyCode, WORD wID, HWND hWndCtl, BOOL& bHandled);
	//  LRESULT NotifyHandler(int idCtrl, LPNMHDR pnmh, BOOL& bHandled);

	// IViewObjectEx
	DECLARE_VIEW_STATUS(VIEWSTATUS_SOLIDBKGND | VIEWSTATUS_OPAQUE)

	// ISeraphyScriptTools_Instance
public:
	STDMETHOD(get_Version)(/*[out, retval]*/ double *pVal);
	STDMETHOD(get_MousePosY)(/*[out, retval]*/ long *pVal);
	STDMETHOD(get_MousePosX)(/*[out, retval]*/ long *pVal);
	STDMETHOD(get_Keyboard)(/*[in]*/VARIANT vk, /*[out, retval]*/ BOOL *pVal);
	_bstr_t m_bstr_ProfilePath;
	STDMETHOD(get_WaitCursor)(/*[out, retval]*/ short *pVal);
	STDMETHOD(put_WaitCursor)(/*[in]*/ short newVal);
	STDMETHOD(get_MainFrame)(/*[out, retval]*/ VARIANT *pVal);
	STDMETHOD(WaitEvent)(/*[in,optional]*/VARIANT varTim,/*[out,retval]*/VARIANT* pvarUnk);
	STDMETHOD(CreateFrame)(/*[out,retval]*/VARIANT* pvarUnk);
	STDMETHOD(get_Dialog)(/*[out, retval]*/ VARIANT *pVal);

protected:
	HRESULT OnDraw(ATL_DRAWINFO& di)
	{
		RECT& rc = *(RECT*)di.prcBounds;
		Rectangle(di.hdcDraw, rc.left, rc.top, rc.right, rc.bottom);

		SetTextAlign(di.hdcDraw, TA_CENTER | TA_BASELINE);
		LPCTSTR pszText = _T("SeraphyScriptTools");
		TextOut(di.hdcDraw,
			(rc.left + rc.right) / 2,
			(rc.top + rc.bottom) / 2,
			pszText,
			lstrlen(pszText));

		return S_OK;
	}

public:
	CComBSTR m_bstrCaption; // FIXME: protectedɂ

protected:
	void PurgeUnusedWindows();
	std::list<CComObject<COverlappedWindow>*> m_lstOverlappedWnd;
	CComObject<CCommDialog>* m_pCommDlg; //FIXME: CComPtr
	CComObject<COverlappedWindow>* m_pMainWindow; //FIXME: CComPtr
	int m_dWaitCursor;
};
