// Instance.cpp : CInstance ̃Cve[V

#include "stdafx.h"
#include "SeraphyScriptTools.h"
#include "Instance.h"
#include "profilesection.h"

/////////////////////////////////////////////////////////////////////////////
// CInstance

HRESULT CInstance::FinalConstruct()
{
	HRESULT hr;

	// CEBhE̐
	m_pMainWindow = NULL;
	if (FAILED(hr = CComObject<COverlappedWindow>::CreateInstance(&m_pMainWindow))) {
		ATLASSERT(SUCCEEDED(hr));
		return hr;
	}
	m_pMainWindow->AddRef(); // CX^XϐɕێQƃJE^+1

	// R_CAOC^[tFCX̐
	m_pCommDlg = NULL;
	if (FAILED(hr = CComObject<CCommDialog>::CreateInstance(&m_pCommDlg))) {
		ATLASSERT(SUCCEEDED(hr));
		// CEBhE͔j.
		m_pMainWindow->Release();
		return hr;
	}
	m_pCommDlg->AddRef();

	// CEBhER_CAOC^[tFCXɐڑ
	CComPtr<IUnknown> pUnk;
	if (FAILED(hr = m_pMainWindow->QueryInterface(&pUnk))) {
		m_pCommDlg->Release();
		m_pMainWindow->Release();
		return hr;
	}

	CComVariant varUnk(pUnk);
	m_pCommDlg->SetMainWindow(varUnk);

	// I[o[bvEBhEXgɒǉQƃJE^+1
	m_pMainWindow->AddRef();
	m_lstOverlappedWnd.push_back(m_pMainWindow);

	// EFCgJ[\EJEg
	m_dWaitCursor = 0;

	return S_OK;
}

void CInstance::FinalRelease()
{
	ATLTRACE("CInstance::FinalRelease\r\n");

	// CEBhẺ
	ATLTRACE(_TEXT("*refcount=%d\n"), m_pMainWindow->m_dwRef);
	if (m_pMainWindow) {
		m_pMainWindow->Release();
		//m_pMainWindow = NULL;
	}

	// R_CAOC^[tFCX̉
	ATLTRACE(_TEXT("*refcount=%d\n"), m_pMainWindow->m_dwRef);
	if (m_pCommDlg) {
		m_pCommDlg->Release();
		m_pCommDlg = NULL;
	}

	// |bvAbvEBhẺ
	ATLTRACE(_TEXT("*refcount=%d\n"), m_pMainWindow->m_dwRef);
	std::list<CComObject<COverlappedWindow>*>::iterator p = m_lstOverlappedWnd.begin();
	while (p != m_lstOverlappedWnd.end()) {
		(*p)->Close();
		(*p)->Release();
		p = m_lstOverlappedWnd.erase(p);
	}
}

STDMETHODIMP CInstance::get_Dialog(VARIANT *pVal)
{
	if (!pVal) {
		return E_POINTER;
	}
	// R_CAOC^[tFCXԂ
	::VariantInit(pVal);
	if (m_pCommDlg) {
		HRESULT hr;
		CComPtr<IUnknown> pUnk;
		if (FAILED(hr = m_pCommDlg->QueryInterface(&pUnk))) {
			return hr;
		}
		pVal->vt = VT_UNKNOWN;
		pVal->punkVal = pUnk.Detach();
	}
	return S_OK;
}

void CInstance::PurgeUnusedWindows()
{
	// QƃJEg1ȂEBhE̔js
	std::list<CComObject<COverlappedWindow>*>::iterator p = m_lstOverlappedWnd.begin();
	while (p != m_lstOverlappedWnd.end()) {
		if ((*p)->m_dwRef == 1) {
			// QƃJEg1Ȃ = ̃NXgĂȂ = sv
			BOOL bVisible = false;
			HRESULT hr = (*p)->get_Visible(&bVisible);
			if (SUCCEEDED(hr) && !bVisible) {
				// \ĂȂΏĂ悵B
				(*p)->Release();
				p = m_lstOverlappedWnd.erase(p);
				continue;
			}
		}
		p++;
	}
}

STDMETHODIMP CInstance::CreateFrame(VARIANT *pvarUnk)
{
	if (!pvarUnk) {
		return E_POINTER;
	}

	::VariantInit(pvarUnk);

	// gp̃EBhE폜
	PurgeUnusedWindows();

	HRESULT hr;

	// EBhE̐
	CComObject<COverlappedWindow>* pNewWnd = NULL;
	if (FAILED(hr = CComObject<COverlappedWindow>::CreateInstance(&pNewWnd))) {
		return hr;
	}

	// C^[tFCX̎擾
	CComPtr<IUnknown> pUnk;
	if (FAILED(hr = pNewWnd->QueryInterface(&pUnk))) {
		delete pNewWnd;
		return hr;
	}

	// EFCgJ[\Ԃ̐ݒ
	pNewWnd->put_WaitCursor(m_dWaitCursor);

	// QƃJEg̒ǉ
	// ǗEBhEXgւ̕ۑ
	pNewWnd->AddRef();
	m_lstOverlappedWnd.push_back(pNewWnd);

	pvarUnk->vt = VT_UNKNOWN;
	pvarUnk->punkVal = pUnk.Detach();
	return S_OK;
}

STDMETHODIMP CInstance::WaitEvent(VARIANT varTim, VARIANT *pvarUnk)
{
	if (!pvarUnk) {
		return E_POINTER;
	}

	::VariantInit(pvarUnk);
	// ҋ@Ԃ̎擾
	DWORD sleeptim = 1000;
	CComVariant tim;
	if (tim.ChangeType(VT_I4, &varTim) == S_OK) {
		sleeptim = (DWORD)tim.lVal;
	}
	if (sleeptim == 0) {
		sleeptim = INFINITE;
	}
	// ׂẴ|bvAbvEBhẼCxgnh擾
	HANDLE hEvent[MAXIMUM_WAIT_OBJECTS] = {NULL};
	HWND   hWnd[MAXIMUM_WAIT_OBJECTS] = {NULL};

	CComObject<COverlappedWindow>* pOverlapped[MAXIMUM_WAIT_OBJECTS] = {0};

	int count = 0;
	int n = 0;
	std::list<CComObject<COverlappedWindow>*>::iterator p = m_lstOverlappedWnd.begin();
	while (p != m_lstOverlappedWnd.end()) {
		n = count;
		(*p)->SetWaitParam(&count, hWnd, hEvent);
		for (; n < count; n++) {
			pOverlapped[n] = *p;
		}
		p++;
	}

	// bZ[W[v
	if (count > 0) {
		DWORD ret = pOverlapped[0]->MessageLoop(sleeptim, count, hWnd, hEvent);
		if (ret > 0 && ret <= (DWORD)count) {
			if (pOverlapped[ret - 1]) {
				// OVERLAPPEDWINDOWIuWFNgւ̃C^[tFCXԂ
				CComPtr<IUnknown> pUnk;
				if (SUCCEEDED(pOverlapped[ret - 1]->QueryInterface(&pUnk))) {
					pvarUnk->vt = VT_UNKNOWN;
					pvarUnk->punkVal = pUnk.Detach();
				}
			}
		}
	}
	return S_OK;
}

STDMETHODIMP CInstance::get_MainFrame(VARIANT *pVal)
{
	if (!pVal) {
		return E_POINTER;
	}

	::VariantInit(pVal);
	if (m_pMainWindow) {
		HRESULT hr;
		CComPtr<IUnknown> pUnk;
		if (FAILED(hr = m_pMainWindow->QueryInterface(&pUnk))) {
			return hr;
		}
		pVal->vt = VT_UNKNOWN;
		pVal->punkVal = pUnk.Detach();
	}
	return S_OK;
}

STDMETHODIMP CInstance::get_WaitCursor(short *pVal)
{
	if (!pVal) {
		return E_POINTER;
	}

	*pVal = m_dWaitCursor;

	return S_OK;
}

STDMETHODIMP CInstance::put_WaitCursor(short newVal)
{
	m_dWaitCursor = newVal;

	// ׂẴ|bvAbvEBhEɃEFCgJ[\lݒ肷
	std::list<CComObject<COverlappedWindow>*>::iterator p = m_lstOverlappedWnd.begin();
	while (p != m_lstOverlappedWnd.end()) {
		(*p)->put_WaitCursor(newVal);
		p++;
	}
	return S_OK;
}

STDMETHODIMP CInstance::get_Keyboard(VARIANT vk, BOOL *pVal)
{
	if (!pVal) {
		return E_POINTER;
	}

	HRESULT hr;
	CComVariant varVk;
	if (FAILED(hr = varVk.ChangeType(VT_I2, &vk))) {
		return hr;
	}
	*pVal = (GetAsyncKeyState(varVk.iVal) & 0x8000) ? VB_TRUE : VB_FALSE;
	return S_OK;
}

STDMETHODIMP CInstance::get_MousePosX(long *pVal)
{
	if (!pVal) {
		return E_POINTER;
	}

	POINT pt;
	::GetCursorPos(&pt);
	*pVal = pt.x;

	return S_OK;
}

STDMETHODIMP CInstance::get_MousePosY(long *pVal)
{
	if (!pVal) {
		return E_POINTER;
	}

	POINT pt;
	::GetCursorPos(&pt);
	*pVal = pt.y;

	return S_OK;
}

STDMETHODIMP CInstance::get_Version(double *pVal)
{
	if (!pVal) {
		return E_POINTER;
	}

	*pVal = 0.93;

	return S_OK;
}
