// Event.h : CEvent ̐錾

#pragma once

#include "resource.h"       // C V{

/////////////////////////////////////////////////////////////////////////////
// CEvent
class ATL_NO_VTABLE CEvent :
	public CComObjectRootEx<CComSingleThreadModel>,
	public CComCoClass<CEvent, &CLSID_Event>,
	public ISupportErrorInfoImpl<&IID_IEvent>,
	public IConnectionPointContainerImpl<CEvent>,
	public IDispatchImpl<IEvent, &IID_IEvent, &LIBID_SERAPHYSCRIPTTOOLSLib>
{
public:
	CEvent()
	{
		m_message = 0;
		m_param = 0;
		m_lparam = 0;
		m_time = 0.;
		m_ptDP.x = 0;
		m_ptDP.y = 0;
		m_ptLP.x = 0;
		m_ptLP.y = 0;
	}

	//DECLARE_REGISTRY_RESOURCEID(IDR_EVENT)

	DECLARE_PROTECT_FINAL_CONSTRUCT()

	BEGIN_COM_MAP(CEvent)
		COM_INTERFACE_ENTRY(IEvent)
		COM_INTERFACE_ENTRY(IDispatch)
		COM_INTERFACE_ENTRY(ISupportErrorInfo)
		COM_INTERFACE_ENTRY(IConnectionPointContainer)
	END_COM_MAP()
	BEGIN_CONNECTION_POINT_MAP(CEvent)
	END_CONNECTION_POINT_MAP()

	// IEvent
public:
	STDMETHOD(IsKeydown2)(/*[out,retval]*/BOOL* pResult);
	STDMETHOD(get_DPosY)(/*[out, retval]*/ long *pVal);
	STDMETHOD(get_DPosX)(/*[out, retval]*/ long *pVal);
	STDMETHOD(IsKeydown)(/*[out,retval]*/BOOL* pResult);
	STDMETHOD(IsContextDelete)(/*[out,retval]*/BOOL* pResult);
	STDMETHOD(IsContextMenu)(/*[out,retval]*/BOOL* pResult);
	STDMETHOD(get_ExtParameter)(/*[out, retval]*/ long *pVal);
	STDMETHOD(IsRDblClick)(/*[out,retval]*/BOOL* pResult);
	STDMETHOD(IsDblClick)(/*[out,retval]*/BOOL* pResult);
	STDMETHOD(IsCancel)(/*[out,retval]*/BOOL* pResult);
	STDMETHOD(IsOK)(/*[out,retval]*/BOOL* pResult);
	STDMETHOD(IsExit)(/*[out,retval]*/BOOL* pResult);
	STDMETHOD(IsSize)(/*[out,retval]*/BOOL* pResult);
	STDMETHOD(IsTimer)(/*[out,retval]*/BOOL* pResult);
	STDMETHOD(IsCommand)(/*[out,retval]*/BOOL* pResult);
	STDMETHOD(IsRClickOut)(/*[out,retval]*/BOOL* pResult);
	STDMETHOD(IsClickOut)(/*[out,retval]*/BOOL* pResult);
	STDMETHOD(IsRClickCancel)(/*[out,retval]*/BOOL* pResult);
	STDMETHOD(IsClickCancel)(/*[out,retval]*/BOOL* pResult);
	STDMETHOD(IsRClick)(/*[out,retval]*/BOOL* pResult);
	STDMETHOD(IsClick)(/*[out,retval]*/BOOL* pResult);
	STDMETHOD(IsMouseMove)(/*[out,retval]*/BOOL* pResult);
	STDMETHOD(get_time)(/*[out, retval]*/ DATE *pVal);
	STDMETHOD(get_PosY)(/*[out, retval]*/ double *pVal);
	STDMETHOD(get_PosX)(/*[out, retval]*/ double *pVal);
	STDMETHOD(get_Parameter)(/*[out, retval]*/ short *pVal);
	STDMETHOD(get_Message)(/*[out, retval]*/ short *pVal);

public:
	short GetMessage(){ return m_message; }
	short GetParam()  { return m_param; }
	DWORD GetLParam() { return m_lparam; }
	void SetData(short message, short wParam, DWORD lParam, POINT& pt, POINT& lp);

protected:
	POINT m_ptDP;
	POINT m_ptLP;
	short m_message;
	short m_param;
	DWORD m_lparam;
	double m_time;
};
