// Event.cpp : CEvent ̃Cve[V
#include "stdafx.h"
#include "SeraphyScriptTools.h"
#include "Event.h"
#include "generic.h"

/////////////////////////////////////////////////////////////////////////////
// CEvent

STDMETHODIMP CEvent::get_Message(short *pVal)
{
	*pVal = m_message;
	return S_OK;
}

STDMETHODIMP CEvent::get_Parameter(short *pVal)
{
	*pVal = m_param;
	return S_OK;
}

STDMETHODIMP CEvent::get_ExtParameter(long *pVal)
{
	*pVal = (long)m_lparam;
	return S_OK;
}

STDMETHODIMP CEvent::get_PosX(double *pVal)
{
	*pVal = (double)m_ptLP.x / 10.;
	return S_OK;
}

STDMETHODIMP CEvent::get_PosY(double *pVal)
{
	*pVal = (double)m_ptLP.y / 10.;
	return S_OK;
}


STDMETHODIMP CEvent::get_DPosX(long *pVal)
{
	*pVal = (long)m_ptDP.x;
	return S_OK;
}

STDMETHODIMP CEvent::get_DPosY(long *pVal)
{
	*pVal = (long)m_ptDP.y;
	return S_OK;
}

STDMETHODIMP CEvent::get_time(DATE *pVal)
{
	*pVal = m_time;
	return S_OK;
}

void CEvent::SetData(short message, short wParam, DWORD lParam, POINT& pt, POINT& lp)
{
	SYSTEMTIME systim;
	GetLocalTime(&systim);
	SystemTimeToVariantTime(&systim, &m_time);
	m_ptDP = pt;
	m_ptLP = lp;
	m_message = message;
	m_param = wParam;
	m_lparam = lParam;
}

STDMETHODIMP CEvent::IsMouseMove(BOOL *pResult)
{
	*pResult = (m_message == WM_MOUSEMOVE) ? VB_TRUE : VB_FALSE;
	return S_OK;
}

STDMETHODIMP CEvent::IsClick(BOOL *pResult)
{
	*pResult = (m_message == WM_LBUTTONDOWN) ? VB_TRUE : VB_FALSE;
	return S_OK;
}

STDMETHODIMP CEvent::IsRClick(BOOL *pResult)
{
	*pResult = (m_message == WM_RBUTTONDOWN) ? VB_TRUE : VB_FALSE;
	return S_OK;
}

STDMETHODIMP CEvent::IsClickCancel(BOOL *pResult)
{
	*pResult = (m_message == WM_CAPTURECHANGED &&
		m_param == 1) ? VB_TRUE : VB_FALSE;
	return S_OK;
}

STDMETHODIMP CEvent::IsRClickCancel(BOOL *pResult)
{
	*pResult = (m_message == WM_CAPTURECHANGED &&
		m_param == 2) ? VB_TRUE : VB_FALSE;
	return S_OK;
}

STDMETHODIMP CEvent::IsClickOut(BOOL *pResult)
{
	*pResult = (m_message == WM_LBUTTONUP) ? VB_TRUE : VB_FALSE;
	return S_OK;
}

STDMETHODIMP CEvent::IsRClickOut(BOOL *pResult)
{
	*pResult = (m_message == WM_RBUTTONUP) ? VB_TRUE : VB_FALSE;
	return S_OK;
}

STDMETHODIMP CEvent::IsCommand(BOOL *pResult)
{
	*pResult = (m_message == WM_COMMAND &&
		(m_param > IDABORT)) ? VB_TRUE : VB_FALSE;
	return S_OK;
}

STDMETHODIMP CEvent::IsTimer(BOOL *pResult)
{
	*pResult = (m_message == WM_TIMER) ? VB_TRUE : VB_FALSE;
	return S_OK;
}

STDMETHODIMP CEvent::IsSize(BOOL *pResult)
{
	*pResult = (m_message == WM_SIZE) ? VB_TRUE : VB_FALSE;
	return S_OK;
}

STDMETHODIMP CEvent::IsExit(BOOL *pResult)
{
	*pResult = (m_message == WM_COMMAND &&
		m_param == IDABORT) ? VB_TRUE : VB_FALSE;
	return S_OK;
}

STDMETHODIMP CEvent::IsOK(BOOL *pResult)
{
	*pResult = (m_message == WM_COMMAND &&
		m_param == IDOK) ? VB_TRUE : VB_FALSE;
	return S_OK;
}

STDMETHODIMP CEvent::IsCancel(BOOL *pResult)
{
	*pResult = (m_message == WM_COMMAND &&
		m_param == IDCANCEL) ? VB_TRUE : VB_FALSE;
	return S_OK;
}

STDMETHODIMP CEvent::IsDblClick(BOOL *pResult)
{
	*pResult = (m_message == WM_LBUTTONDBLCLK) ? VB_TRUE : VB_FALSE;
	return S_OK;
}

STDMETHODIMP CEvent::IsRDblClick(BOOL *pResult)
{
	*pResult = (m_message == WM_RBUTTONDBLCLK) ? VB_TRUE : VB_FALSE;
	return S_OK;
}

STDMETHODIMP CEvent::IsContextMenu(BOOL *pResult)
{
	*pResult = (m_message == WM_NOTIFY && m_lparam == VK_RBUTTON) ? VB_TRUE : VB_FALSE;
	return S_OK;
}

STDMETHODIMP CEvent::IsContextDelete(BOOL *pResult)
{
	*pResult = (m_message == WM_NOTIFY && m_lparam == VK_DELETE) ? VB_TRUE : VB_FALSE;
	return S_OK;
}

STDMETHODIMP CEvent::IsKeydown(BOOL *pResult)
{
	*pResult = (m_message == WM_KEYDOWN) ? VB_TRUE : VB_FALSE;
	return S_OK;
}

STDMETHODIMP CEvent::IsKeydown2(BOOL *pResult)
{
	*pResult = (m_message == WM_KEYDOWN_EX) ? VB_TRUE : VB_FALSE;
	return S_OK;
}
