#ifndef __DELAY_H__

#define __DELAY_H__

#include <libpic30.h>

#define FOSC    8000000LL   // Clock Freqency Hz
#define FCY  (FOSC/2)  // FCY 動作周波数[ Hz ]

#define delay_us(x) __delay32(((x*FCY)/1000000L)) // delays x us
#define delay_ms(x) __delay32(((x*FCY)/1000L))  // delays x ms

#endif
