
#ifndef __MYUART_H__

#define __MYUART_H__

#include <p24FJ64GA004.h>

#define uart1_tx_is_full() (U1STAbits.UTXBF == 1)
#define uart2_tx_is_full() (U2STAbits.UTXBF == 1)

#define uart1_rx_is_rdy()  (U1STAbits.URXDA == 1)
#define uart2_rx_is_rdy()  (U2STAbits.URXDA == 1)

#define uart1_putc(c)    U1TXREG = (c)
#define uart2_putc(c)    U2TXREG = (c)

#define uart1_getc(c)    U1RXREG
#define uart2_getc(c)    U2RXREG

// 割り込みレベル　デフォルト4
#define uart1_set_int_level(i)  IPC2bits.U1RXIP = (i)
#define uart1_rx_int_enable()  IEC0bits.U1RXIE = 1
#define uart1_rx_int_disable()  IEC0bits.U1RXIE = 0
#define uart1_rx_intf_clear()    IFS0bits.U1RXIF = 0  // 割り込みフラグクリア

#define uart2_set_int_level(i)  IPC7bits.U2RXIP = (i)
#define uart2_rx_int_enable()  IEC1bits.U2RXIE = 1
#define uart2_rx_int_disable()  IEC1bits.U2RXIE = 0
#define uart2_rx_intf_clear()    IFS1bits.U2RXIF = 0  // 割り込みフラグクリア


void uart1_puts(char *s);
void uart2_puts(char *s);
void uart1_myputc(char c);
void uart2_myputc(char c);

int uart1_rcvbuf_is_data(void);
int uart2_rcvbuf_is_data(void);
int uart1_rcvbuf_getc(void);
int uart2_rcvbuf_getc(void);
void uart1_rcvbuf_clear(void);
void uart2_rcvbuf_clear(void);

void uart1_init(unsigned int mode, unsigned int sts, unsigned int baud);
void uart2_init(unsigned int mode, unsigned int sts, unsigned int baud);

#endif
