package jp.sourceforge.tamanegisoul.sa.widget;

import java.util.Calendar;

import android.app.AlertDialog.Builder;
import android.content.Context;
import android.content.DialogInterface;
import android.preference.ListPreference;
import android.util.AttributeSet;

public class ListPreferenceMultiSelect extends ListPreference {

    private static final String SEPARATOR = ",";

    private boolean[] mCheckedIndices;

    public ListPreferenceMultiSelect(Context context) {
        this(context, null);
    }

    public ListPreferenceMultiSelect(Context context, AttributeSet attrs) {
        super(context, attrs);
        mCheckedIndices = new boolean[getEntries().length];
    }

    @Override
    public void setEntries(CharSequence[] entries) {
        super.setEntries(entries);
        mCheckedIndices = new boolean[entries.length];
    }

    @Override
    protected void onPrepareDialogBuilder(Builder builder) {
        CharSequence[] entries = getEntries();
        restoreCheckedEntries();
        builder.setMultiChoiceItems(entries, mCheckedIndices, new DialogInterface.OnMultiChoiceClickListener() {
            public void onClick(DialogInterface dialog, int which, boolean val) {
                mCheckedIndices[which] = val;
            }
        });
    }

    public static String[] parseStoredValue(CharSequence val) {
        if (val == null || "".equals(val))
            return null;
        else
            return ((String) val).split(SEPARATOR);
    }

    private void restoreCheckedEntries() {
        CharSequence[] entryValues = getEntryValues();
        String[] vals = parseStoredValue(getValue());
        if (vals != null) {
            for (int j = 0; j < vals.length; j++) {
                String val = vals[j].trim();
                for (int i = 0; i < entryValues.length; i++) {
                    CharSequence entry = entryValues[i];
                    if (entry.equals(val)) {
                        mCheckedIndices[i] = true;
                        break;
                    }
                }
            }
        }
    }

    @Override
    protected void onDialogClosed(boolean positiveResult) {
        CharSequence[] entryValues = getEntryValues();
        if (positiveResult && entryValues != null) {
            StringBuffer value = new StringBuffer();
            for (int i = 0; i < entryValues.length; i++) {
                if (mCheckedIndices[i]) {
                    value.append(entryValues[i]).append(SEPARATOR);
                }
            }
            if (callChangeListener(value)) {
                String val = value.toString();
                if (val.length() > 0)
                    val = val.substring(0, val.length() - SEPARATOR.length());
                setValue(val);
            }
            setSummary(getSummary());
        }
    }

    @Override
    public CharSequence getSummary() {
        StringBuilder summary = new StringBuilder();
        String[] vals = parseStoredValue(getValue());
        if (vals == null || vals.length == 0) {
            summary.append("なし");
        } else {
            for (int j = 0; j < vals.length; j++) {
                int val = Integer.parseInt(vals[j].trim());
                if (val == Calendar.SUNDAY) {
                    summary.append("日曜").append(",");
                } else if (val == Calendar.MONDAY) {
                    summary.append("月曜").append(",");
                } else if (val == Calendar.TUESDAY) {
                    summary.append("火曜").append(",");
                } else if (val == Calendar.WEDNESDAY) {
                    summary.append("水曜").append(",");
                } else if (val == Calendar.THURSDAY) {
                    summary.append("木曜").append(",");
                } else if (val == Calendar.FRIDAY) {
                    summary.append("金曜").append(",");
                } else if (val == Calendar.SATURDAY) {
                    summary.append("土曜").append(",");
                }
            }
            summary.deleteCharAt(summary.length() - 1);
        }
        return summary.toString();
    }
}