/*
 * Decompiled with CFR 0.152.
 */
package com.google.storage.speckle.jdbc.internal;

import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.protos.speckle.Client;
import com.google.protos.speckle.sql.CloseConnectionRequest;
import com.google.protos.speckle.sql.CloseConnectionResponse;
import com.google.protos.speckle.sql.ExecOpRequest;
import com.google.protos.speckle.sql.ExecOpResponse;
import com.google.protos.speckle.sql.ExecRequest;
import com.google.protos.speckle.sql.ExecResponse;
import com.google.protos.speckle.sql.MetadataRequest;
import com.google.protos.speckle.sql.MetadataResponse;
import com.google.protos.speckle.sql.OpenConnectionRequest;
import com.google.protos.speckle.sql.OpenConnectionResponse;
import com.google.storage.speckle.jdbc.internal.AbstractSpeckleClient;
import com.google.storage.speckle.jdbc.internal.SpeckleRpc;
import com.google.storage.speckle.jdbc.internal.SpeckleRpcOptions;
import com.google.storage.speckle.jdbc.internal.SpeckleUrl;
import com.google.storage.speckle.jdbc.internal.TypedValue;
import com.google.storage.speckle.jdbc.internal.Util;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpeckleProtoClient
extends AbstractSpeckleClient {
    private static final Logger LOG = Logger.getLogger(SpeckleProtoClient.class.getName());
    private final SpeckleRpc rpc;

    public SpeckleProtoClient(String speckleInstance, SpeckleRpc stub) {
        super(speckleInstance);
        this.rpc = Util.checkNotNull(stub, "stub can not be null");
        LOG.log(Level.FINE, "Created client for instance: {0}", speckleInstance);
    }

    @Override
    public OpenConnectionResponse openConnection(SpeckleRpcOptions options, SpeckleUrl url) throws SQLException {
        LOG.log(Level.FINE, "Executing Connect: {0} at {1}/{2}", new Object[]{url.getUser(), url.getInstance(), url.getDatabase()});
        OpenConnectionRequest request = this.createConnectRequest(url);
        OpenConnectionResponse response = this.rpc.openConnection(options, request);
        LOG.log(Level.FINEST, "Stubby response: {0}", response);
        return response;
    }

    @Override
    public CloseConnectionResponse closeConnection(SpeckleRpcOptions options, ByteString connectionId) throws SQLException {
        LOG.log(Level.FINE, "Executing Release: {0}", connectionId);
        CloseConnectionRequest request = this.createReleaseRequest(connectionId);
        CloseConnectionResponse response = this.rpc.closeConnection(options, request);
        LOG.log(Level.FINEST, "Stubby response: {0}", response);
        return response;
    }

    @Override
    public ExecResponse executeSql(SpeckleRpcOptions options, ByteString connectionId, String sql) throws SQLException {
        return this.executeSql(options, connectionId, sql, Collections.<TypedValue>emptyList());
    }

    @Override
    public ExecResponse executeSql(SpeckleRpcOptions options, ByteString connectionId, String sql, List<TypedValue> bindParameters) throws SQLException {
        LOG.log(Level.FINE, "Executing SQL: {0}", sql);
        ExecRequest request = this.createExecRequest(options, connectionId, sql, bindParameters);
        ExecResponse response = this.rpc.exec(options, request);
        LOG.log(Level.FINEST, "Stubby response = {0}", response);
        return response;
    }

    @Override
    public ExecResponse executeNext(SpeckleRpcOptions options, ByteString connectionId, long statementId) throws SQLException {
        LOG.log(Level.FINE, "Executing SQL: {0}", statementId);
        ExecRequest request = this.createExecNextRequest(options, connectionId, statementId);
        ExecResponse response = this.rpc.exec(options, request);
        LOG.log(Level.FINEST, "Stubby response = {0}", response);
        return response;
    }

    @Override
    public ExecOpResponse executeOperation(SpeckleRpcOptions options, ByteString connectionId, Client.OpProto op) throws SQLException {
        LOG.log(Level.FINE, "Executing Operation: {0}", op.getType().name());
        ExecOpRequest request = this.createExecOpRequest(connectionId, op);
        ExecOpResponse response = this.rpc.execOp(options, request);
        LOG.log(Level.FINEST, "Stubby response = {0}", response);
        return response;
    }

    @Override
    public final MetadataResponse getMetadata(SpeckleRpcOptions options, ByteString connectionId, Client.MetadataType metadataType, List<TypedValue> bindParameters) throws SQLException {
        LOG.log(Level.FINE, "Executing metadata request for type: {0}", metadataType);
        MetadataRequest request = this.createMetadataRequest(connectionId, metadataType, bindParameters);
        MetadataResponse response = this.rpc.getMetadata(options, request);
        LOG.log(Level.FINEST, "Stubby response: {0}", response);
        return response;
    }

    @Override
    public SpeckleRpc getRpc() {
        return this.rpc;
    }
}

