/*
 * Decompiled with CFR 0.152.
 */
package com.google.storage.speckle.jdbc.internal;

import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.protos.speckle.Client;
import com.google.storage.speckle.jdbc.SpeckleResultSet;
import com.google.storage.speckle.jdbc.internal.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SimpleListResultSet
extends SpeckleResultSet {
    private SimpleListResultSet(List<List<?>> data, List<String> columnNames) {
        super(null, SimpleListResultSet.createData(data), SimpleListResultSet.createColumns(columnNames), null, "", 1004, 1007, 2);
    }

    private static List<Client.ColumnProto> createColumns(List<String> columnNames) {
        ArrayList<Client.ColumnProto> results = Util.newArrayList();
        for (String columnName : columnNames) {
            results.add(Client.ColumnProto.newBuilder().setName(columnName).setLabel(columnName).build());
        }
        return results;
    }

    private static List<Client.TupleProto> createData(List<List<?>> data) {
        ArrayList<Client.TupleProto> results = Util.newArrayList();
        for (List<?> row : data) {
            Client.TupleProto.Builder builder = Client.TupleProto.newBuilder();
            int current = 0;
            for (Object cell : row) {
                if (cell == null) {
                    builder.addNulls(current);
                    continue;
                }
                builder.addValues(ByteString.copyFromUtf8(String.valueOf(cell)));
            }
            results.add(builder.build());
        }
        return results;
    }

    public static SimpleListResultSet emptyResultSet() {
        List<List<?>> rows = Collections.emptyList();
        return new SimpleListResultSet(rows, Collections.<String>emptyList());
    }

    public static SimpleListResultSet emptyResultSet(Enum<?> ... columnNames) {
        List<List<?>> rows = Collections.emptyList();
        return SimpleListResultSet.newEnumResultSet(rows, columnNames);
    }

    public static SimpleListResultSet oneColumnResultSet(List<?> data, String columnName) {
        Util.checkNotNull(columnName, "columnName may not be null");
        ArrayList<List<?>> rows = Util.newArrayList();
        for (Object type : data) {
            rows.add(Collections.singletonList(type));
        }
        return new SimpleListResultSet(rows, Collections.singletonList(columnName));
    }

    public static SimpleListResultSet newEnumResultSet(List<List<?>> data, Enum<?> ... columnNames) {
        Util.checkNotNull(columnNames, "columnName may not be null");
        ArrayList<String> columnNamesString = Util.newArrayList();
        for (Enum<?> columnName : columnNames) {
            columnNamesString.add(columnName.name());
        }
        return new SimpleListResultSet(data, columnNamesString);
    }

    public static SimpleListResultSet newOneColumnEnumResultSet(List<?> data, Enum<?> columnName) {
        ArrayList<List<?>> rows = Util.newArrayList();
        for (Object row : data) {
            rows.add(Collections.singletonList(row));
        }
        return SimpleListResultSet.newEnumResultSet(rows, columnName);
    }

    public static SimpleListResultSet newResultSet(List<List<?>> rows, List<String> columnNames) {
        return new SimpleListResultSet(rows, columnNames);
    }
}

