/*
 * Decompiled with CFR 0.152.
 */
package com.google.storage.speckle.jdbc;

import com.google.protos.speckle.sql.OpenConnectionResponse;
import com.google.storage.speckle.jdbc.SpeckleConnection;
import com.google.storage.speckle.jdbc.internal.Exceptions;
import com.google.storage.speckle.jdbc.internal.SpeckleClient;
import com.google.storage.speckle.jdbc.internal.SpeckleClientFactory;
import com.google.storage.speckle.jdbc.internal.SpeckleRpcOptions;
import com.google.storage.speckle.jdbc.internal.SpeckleUrl;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Properties;

public class SpeckleDriver
implements Driver {
    protected final SpeckleClientFactory clientFactory;
    static final String MULTIPLE_PROVIDER_ERROR = "Cannot register multiple SpeckleClientFactory implementations.";
    static final String NO_PROVIDER_ERROR = "No SpeckleClientFactory implementation was registered.";

    protected SpeckleDriver(SpeckleClientFactory clientFactory) {
        this.clientFactory = clientFactory;
    }

    public final boolean acceptsURL(String url) {
        return SpeckleUrl.acceptsUrl(url);
    }

    public Connection connect(String urlStr, Properties info) throws SQLException {
        if (!this.acceptsURL(urlStr)) {
            throw Exceptions.driverUrlNotInCorrectFormat(urlStr);
        }
        SpeckleUrl url = SpeckleUrl.create(urlStr, info);
        SpeckleClient client = this.clientFactory.create(url);
        if (client == null) {
            throw Exceptions.newDriverCanNotConnectException();
        }
        OpenConnectionResponse response = client.openConnection(SpeckleRpcOptions.defaultOptions(url), url);
        if (response.hasSqlException()) {
            throw Exceptions.newSqlException(response.getSqlException());
        }
        return new SpeckleConnection(url, client, response.getConnectionId());
    }

    public final int getMajorVersion() {
        return 1;
    }

    public final int getMinorVersion() {
        return 0;
    }

    public final DriverPropertyInfo[] getPropertyInfo(String url, Properties info) {
        return SpeckleUrl.create(url, info).getDriverPropertyInfos();
    }

    public final boolean jdbcCompliant() {
        return false;
    }
}

