package jp.sourceforge.tamanegisoul.sa.action;

import jp.sourceforge.tamanegisoul.sa.util.AppAlarmManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;

/**
 * 初期化するレシーバー。
 */
public class BootReceiver extends BroadcastReceiver {

    @Override
    public void onReceive(Context context, Intent intent) {
        // サービス起動
        context.startService(new Intent(context.getApplicationContext(), CalendarObserverService.class));
        // アラーム設定
        AppAlarmManager.getInstance(context).clearAlarmTime();
        AppAlarmManager.getInstance(context).refreshAlarm();
    }
}
