package jp.sourceforge.tamanegisoul.sa.util;

import java.lang.Thread.UncaughtExceptionHandler;

import android.content.Context;

public class AppUncaughtExceptionHandler implements UncaughtExceptionHandler {

    private UncaughtExceptionHandler mDefaultHandler;

    public AppUncaughtExceptionHandler(Context context) {
        super();
        mDefaultHandler = Thread.getDefaultUncaughtExceptionHandler();
    }

    @Override
    public void uncaughtException(Thread thread, Throwable throwable) {
        ErrorReporter.storeError(throwable);
        mDefaultHandler.uncaughtException(thread, throwable);
    }



}
