/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.base;

import com.google.appengine.repackaged.com.google.common.annotations.GoogleInternal;
import com.google.appengine.repackaged.com.google.common.annotations.GwtCompatible;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GoogleInternal
@GwtCompatible
public enum RegionCode {
    AD,
    AE,
    AF,
    AG,
    AI,
    AL,
    AM,
    AN,
    AO,
    AQ,
    AR,
    AS,
    AT,
    AU,
    AW,
    AX,
    AZ,
    BA,
    BB,
    BD,
    BE,
    BF,
    BG,
    BH,
    BI,
    BJ,
    BL,
    BM,
    BN,
    BO,
    BR,
    BS,
    BT,
    BU,
    BV,
    BW,
    BY,
    BZ,
    CA,
    CC,
    CD,
    CF,
    CG,
    CH,
    CI,
    CK,
    CL,
    CM,
    CN,
    CO,
    CR,
    CS,
    CU,
    CV,
    CX,
    CY,
    CZ,
    DD,
    DE,
    DJ,
    DK,
    DM,
    DO,
    DZ,
    EC,
    EE,
    EG,
    EH,
    ER,
    ES,
    ET,
    FI,
    FJ,
    FK,
    FM,
    FO,
    FR,
    FX,
    GA,
    GB,
    GD,
    GE,
    GF,
    GG,
    GH,
    GI,
    GL,
    GM,
    GN,
    GP,
    GQ,
    GR,
    GS,
    GT,
    GU,
    GW,
    GY,
    HK,
    HM,
    HN,
    HR,
    HT,
    HU,
    ID,
    IE,
    IL,
    IM,
    IN,
    IO,
    IQ,
    IR,
    IS,
    IT,
    JE,
    JM,
    JO,
    JP,
    KE,
    KG,
    KH,
    KI,
    KM,
    KN,
    KP,
    KR,
    KW,
    KY,
    KZ,
    LA,
    LB,
    LC,
    LI,
    LK,
    LR,
    LS,
    LT,
    LU,
    LV,
    LY,
    MA,
    MC,
    MD,
    ME,
    MF,
    MG,
    MH,
    MK,
    ML,
    MM,
    MN,
    MO,
    MP,
    MQ,
    MR,
    MS,
    MT,
    MU,
    MV,
    MW,
    MX,
    MY,
    MZ,
    NA,
    NC,
    NE,
    NF,
    NG,
    NI,
    NL,
    NO,
    NP,
    NR,
    NT,
    NU,
    NZ,
    OM,
    PA,
    PE,
    PF,
    PG,
    PH,
    PK,
    PL,
    PM,
    PN,
    PR,
    PS,
    PT,
    PW,
    PY,
    QA,
    QO,
    QU,
    RE,
    RO,
    RS,
    RU,
    RW,
    SA,
    SB,
    SC,
    SD,
    SE,
    SG,
    SH,
    SI,
    SJ,
    SK,
    SL,
    SM,
    SN,
    SO,
    SR,
    ST,
    SU,
    SV,
    SY,
    SZ,
    TC,
    TD,
    TF,
    TG,
    TH,
    TJ,
    TK,
    TL,
    TM,
    TN,
    TO,
    TP,
    TR,
    TT,
    TV,
    TW,
    TZ,
    UA,
    UG,
    UM,
    US,
    UY,
    UZ,
    VA,
    VC,
    VE,
    VG,
    VI,
    VN,
    VU,
    WF,
    WS,
    YD,
    YE,
    YT,
    YU,
    ZA,
    ZM,
    ZR,
    ZW,
    ZZ,
    UN001,
    UN002,
    UN003,
    UN005,
    UN009,
    UN011,
    UN013,
    UN014,
    UN015,
    UN017,
    UN018,
    UN019,
    UN021,
    UN029,
    UN030,
    UN034,
    UN035,
    UN039,
    UN053,
    UN054,
    UN057,
    UN061,
    UN142,
    UN143,
    UN145,
    UN150,
    UN151,
    UN154,
    UN155,
    UN419;

    private static final Set<RegionCode> NON_CANONICAL;
    private final String stringForm = this.name().replaceFirst("^UN", "");

    @Deprecated
    private void removeWhenCompilerFixed() {
    }

    public String toString() {
        return this.stringForm;
    }

    public static RegionCode forString(String cldrCode) {
        if (cldrCode.matches("[A-Z]{2}")) {
            return RegionCode.valueOf(cldrCode);
        }
        if (cldrCode.matches("[0-9]{3}")) {
            try {
                return RegionCode.valueOf("UN" + cldrCode);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        throw new IllegalArgumentException("'" + cldrCode + "' is not a valid CLDR region code.");
    }

    public static RegionCode getUnknown() {
        return ZZ;
    }

    public boolean isCanonical() {
        return !NON_CANONICAL.contains((Object)this);
    }

    static {
        HashSet tempSet = new HashSet();
        Collections.addAll(tempSet, BU, CS, DD, FX, NT, SU, TP, YD, YU, ZR);
        NON_CANONICAL = Collections.unmodifiableSet(tempSet);
    }
}

