/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.channel;

import com.google.appengine.api.channel.ChannelFailureException;
import com.google.appengine.api.channel.ChannelMessage;
import com.google.appengine.api.channel.ChannelService;
import com.google.appengine.api.channel.ChannelServicePb;
import com.google.apphosting.api.ApiProxy;
import javax.servlet.http.HttpServletRequest;

class ChannelServiceImpl
implements ChannelService {
    public static final String PACKAGE = "channel";
    public static final String CLIENT_ID_PARAM = "key";
    public static final String MESSAGE_PARAM = "msg";
    public static final int MAXIMUM_CLIENT_ID_CHARS = 64;
    public static final int MAXIMUM_MESSAGE_CHARS = Short.MAX_VALUE;

    ChannelServiceImpl() {
    }

    public String createChannel(String clientId) {
        byte[] responseBytes;
        ChannelServicePb.CreateChannelRequest request = new ChannelServicePb.CreateChannelRequest().setApplicationKey(clientId);
        if (request.getApplicationKeyAsBytes().length > 64) {
            throw this.getExceptionForPrecondition(ChannelServicePb.ChannelServiceError.ErrorCode.INVALID_CHANNEL_KEY);
        }
        try {
            responseBytes = ApiProxy.makeSyncCall(PACKAGE, "CreateChannel", request.toByteArray());
        }
        catch (ApiProxy.ApplicationException e) {
            throw this.getExceptionForError(ChannelServicePb.ChannelServiceError.ErrorCode.valueOf(e.getApplicationError()), e);
        }
        ChannelServicePb.CreateChannelResponse response = new ChannelServicePb.CreateChannelResponse();
        response.mergeFrom(responseBytes);
        return response.getClientId();
    }

    public void sendMessage(ChannelMessage message) {
        ChannelServicePb.SendMessageRequest request = new ChannelServicePb.SendMessageRequest().setApplicationKey(message.getClientId()).setMessage(message.getMessage());
        if (request.getApplicationKeyAsBytes().length > 64) {
            throw this.getExceptionForPrecondition(ChannelServicePb.ChannelServiceError.ErrorCode.INVALID_CHANNEL_KEY);
        }
        if (request.getMessageAsBytes().length > Short.MAX_VALUE) {
            throw this.getExceptionForPrecondition(ChannelServicePb.ChannelServiceError.ErrorCode.BAD_MESSAGE);
        }
        try {
            byte[] responseBytes = ApiProxy.makeSyncCall(PACKAGE, "SendChannelMessage", request.toByteArray());
        }
        catch (ApiProxy.ApplicationException e) {
            throw this.getExceptionForError(ChannelServicePb.ChannelServiceError.ErrorCode.valueOf(e.getApplicationError()), e);
        }
    }

    public ChannelMessage parseMessage(HttpServletRequest request) {
        String clientId = request.getParameter(CLIENT_ID_PARAM);
        String message = request.getParameter(MESSAGE_PARAM);
        if (clientId == null) {
            throw new IllegalStateException("Client id parameter not found in HTTP request.");
        }
        if (message == null) {
            throw new IllegalStateException("Message parameter not found in HTTP request.");
        }
        return new ChannelMessage(clientId, message);
    }

    private RuntimeException getExceptionForPrecondition(ChannelServicePb.ChannelServiceError.ErrorCode errorCode) {
        String description;
        switch (errorCode) {
            case INVALID_CHANNEL_KEY: {
                description = "Invalid client ID. The clientid must be fewer than 64 bytes when encoded to UTF-8.";
                break;
            }
            case BAD_MESSAGE: {
                description = "The message must be fewer than 32767 bytes when encoded to UTF-8.";
                break;
            }
            default: {
                description = "An unexpected error occurred.";
            }
        }
        return new IllegalArgumentException(description);
    }

    private RuntimeException getExceptionForError(ChannelServicePb.ChannelServiceError.ErrorCode errorCode, Exception e) {
        switch (errorCode) {
            case INTERNAL_ERROR: {
                return new ChannelFailureException("An internal channel error occured.");
            }
        }
        return new ChannelFailureException("An unexpected error occurred.", e);
    }
}

