#include <xmodem/xmodem_def.h>
#include <xmodem/xmodem.h>

#ifdef DEBUG_ON_PC
#include <stdio.h>
#endif

static void (*_putchar)( int c );
static int (*_getchar)( int timeout );

#define XMODEM_RECV_BLOCK_NOERR      (1)
#define XMODEM_RECV_BLOCK_BLK_ERR    (-1)
#define XMODEM_RECV_BLOCK_BLK_NO_ERR (-2)
#define XMODEM_RECV_BLOCK_SUM_ERR    (-3)
#define XMODEM_RECV_BLOCK_CRC_ERR    (-4)

static int xmodem_recv_block( unsigned char block_no, xmodem_buffer_t *data )
{
    int i;
    unsigned char blk_no1;
    unsigned char blk_no2;
    unsigned char sum_recv = 0;
    unsigned char sum = 0;
#ifdef DEBUG_ON_PC
    printf ( "Recieving %d\n", block_no );
#endif
    blk_no1 = (unsigned char)_getchar( TIMEOUT );
    blk_no2 = (unsigned char)_getchar( TIMEOUT );

    for ( i = 0; i < XMODEM_BLOCK_SIZE; i ++ )
    {
        unsigned char c;
        c = (unsigned char)_getchar( TIMEOUT );
        *((data->buffer) + i) = c;
#ifdef DEBUG_ON_PC
        if ( !(i % 16) ) printf ( "\n" );
        printf ( " %2.2X", c );
#endif
        sum += c;
    }
    sum_recv = (unsigned char)_getchar( TIMEOUT );

#ifdef DEBUG_ON_PC
    printf ( "\n" );
#endif
    if ( blk_no1 != ~blk_no2 ) return XMODEM_RECV_BLOCK_BLK_ERR;
    if ( blk_no1 != block_no ) return XMODEM_RECV_BLOCK_BLK_NO_ERR;
    if ( sum_recv != sum     ) return XMODEM_RECV_BLOCK_SUM_ERR;
    return XMODEM_RECV_BLOCK_NOERR;
}

static int wait_for_first_soh( void )
{
    int c;
    while ( 1 )
    {
        _putchar ( NAK );
        c = _getchar( SHORT_TIMEOUT );
#ifdef DEBUG_ON_PC
        if ( c != -1 ){printf ( "Got [%2.2X]\n", c );}
#endif
        if ( c == SOH )
        {
            return 1;
        }
        if ( c == CAN || c == EOT )
        {
            return 0;
        }
    }
}

static int wait_for_soh( void )
{
    int c;
    int cancount = 0;
    while ( 1 )
    {
        c = _getchar( SHORT_TIMEOUT );
#ifdef DEBUG_ON_PC
        if ( c != -1 ){printf ( "Got [%2.2X]\n", c );}
#endif
        if ( c == SOH )
        {
            return 1;
        }
        if ( c == CAN )
        {
            cancount ++;
        }
        else
        {
            cancount = 0;
        }
        if ( cancount >= 2 )
        {
            return 0;
        }
    }
}

int xmodem_recv( int retry,
                 void *recv_buffer,
                 void (*set_data_callback)( int block_no, xmodem_buffer_t data ),
                 void (*put_char_callback)(int c),
                 int  (*get_char_callback)(int timeout)  )
{
    unsigned char block_no = 1;

    _putchar = put_char_callback;
    _getchar = get_char_callback;

    if( wait_for_first_soh() )
    {
#ifdef DEBUG_ON_PC
        printf ( "START\n" );
#endif
        xmodem_buffer_t data;
        data.buffer = (unsigned char *)recv_buffer;
        while( 1 )
        {
            int ret;
            int retry_count = retry;

            while ( --retry_count )
            {
                ret = xmodem_recv_block( block_no, &data );
                if ( ret == XMODEM_RECV_BLOCK_NOERR )
                {
                    _putchar( ACK );
                    break;
                }
                else
                {
#ifdef DEBUG_ON_PC
                    printf ( "ERROR %d at %d\n", ret, block_no );
                    printf ( "retry\n" );
#endif
                    _putchar( NAK );
                    continue;
                }
            }

            if ( wait_for_soh() )
            {
                block_no++;
            }
            else
            {
                break;
            }
        }
        _putchar( ACK );
    }
    else 
    {
#ifdef DEBUG_ON_PC
        printf ( "CANCELED\n" );
#endif
    }
#ifdef DEBUG_ON_PC
    printf ( "END\n" );
#endif
    return block_no * XMODEM_BLOCK_SIZE;
}
