#include <sys/types.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <termios.h>
#include <unistd.h>
#include <fcntl.h>
#include <ctype.h>
#include <stdio.h>
#include <string.h>
#include <math.h>
#include <stdlib.h>
//#include <malloc.h>

#include "posix_serial.hpp"


/*!
  port-1ĖI[vԂƂAfoCXt@CdevicenameɃRs[܂B
  \param dev foCXt@C
*/
posix_serial::posix_serial ( char *dev )
{
    port = -1;
    devicename = (char *)malloc ( sizeof(char) * strlen (dev) + 1 );
    strcpy ( devicename, dev );
}

/*!
  A|[gJĂꍇ͕܂B
*/
posix_serial::~posix_serial ( void )
{
    if ( port != -1 )
    {
        close ();
    }
}

/*!
  NXꂽiKł̓|[g͊JĂȂ߁A
  ̃\bhĂяoƂɂĖIɃ|[gJKv܂B
  \param rate Xs[hA50`115200܂ł̈ʓIȐl (default:9600)
  \param parity peB 'N'() 'O'() 'E'() ̂ꂩ (default:'N')
  \param databits f[^rbg 5`8 (default:8)
  \param stopbits Xgbvrbg 1܂2 (default:1)
  \param options termios̃IvV (default:0)
  \return I[vłǂbooll
*/
bool posix_serial::open( int rate, int parity,int databits, int stopbits, int options )
{
    int rtnval = 0;
    struct termios t;

    int local_databits = 0, local_stopbits = 0, local_parity = 0, local_rate = 0;
    char upper_parity = 0;

        /* Check for valid values */

    upper_parity = toupper(parity);

    if (((databits == 5) || (databits == 6) || (databits == 7) || (databits == 8)) &&
        ((stopbits == 2) || (stopbits == 1)) &&
        ((upper_parity == 'N') || (upper_parity == 'O') || (upper_parity == 'E')) &&
        ((rate == 50) || (rate == 75) || (rate == 110) || (rate == 134) || (rate == 150) ||
         (rate == 200) || (rate == 300) || (rate == 600) || (rate == 1200) || (rate == 1800) ||
         (rate == 2400) || (rate == 4800) || (rate == 9600) || (rate == 19200) || (rate == 38400) ||
         (rate == 57600) || (rate == 115200)))
    {

            /* Open the com port for read/write access */

        rtnval = ::open(devicename,O_RDWR);

        if (rtnval != -1)
        {
                /* Set the parity, data bits, and stop bits */

            switch(databits)
            {
                case 5 : local_databits = CS5; break;
                case 6 : local_databits = CS6; break;
                case 7 : local_databits = CS7; break;
                case 8 : local_databits = CS8; break;
            }

            if (stopbits == 2)
                local_stopbits = CSTOPB;
            else
                local_stopbits = 0;

            switch(upper_parity)
            {
                case 'E' : local_parity = PARENB; break;
                case 'O' : local_parity |= PARODD; break;
            }
        }

        t.c_iflag = IGNPAR;
        t.c_oflag = 0;
        t.c_cflag &= ~CSIZE; /* Zero out the CSIZE bits */
        t.c_cflag = CLOCAL | local_databits | local_stopbits | local_parity | options;
        t.c_lflag = IEXTEN;

            /* Set the data rate */

        switch(rate)
        {
            case 50     : local_rate = B50;     break;
            case 75     : local_rate = B75;     break;
            case 110    : local_rate = B110;    break;
            case 134    : local_rate = B134;    break;
            case 150    : local_rate = B150;    break;
            case 200    : local_rate = B200;    break;
            case 300    : local_rate = B300;    break;
            case 600    : local_rate = B600;    break;
            case 1200   : local_rate = B1200;   break;
            case 1800   : local_rate = B1800;   break;
            case 2400   : local_rate = B2400;   break;
            case 4800   : local_rate = B4800;   break;
            case 9600   : local_rate = B9600;   break;
            case 19200  : local_rate = B19200;  break;
            case 38400  : local_rate = B38400;  break;
            case 57600  : local_rate = B57600;  break;
            case 115200 : local_rate = B115200; break;
        }

        if ((cfsetispeed(&t,local_rate) != -1) && (cfsetospeed(&t,local_rate) != -1))
        {
            if (tcsetattr(rtnval,TCSANOW,&t) == -1)
            {
                rtnval = -1;
            }
        }
        else
        {
            rtnval = -1;
        }
    }
    else
    {
        rtnval = -1;
    }

    if ( rtnval == -1 )
    {
        return false;
    }
    port = rtnval;
    return true;
}

/*!
  \return ǂ
*/
bool posix_serial::close()
{
    if (port != -1)
    {
        port = -1;
        return ((int) ::close(port) == 0);
    }
    return true;
}

/*!
  \param timeout ^CAEg(ms)
  \return f[^邩ǂ
*/
bool posix_serial::dataready( int timeout )
{
    struct timeval tvptr;
    fd_set rset;
    int status = -1;
    bool rtnval = false;

    if (port != -1)
    {
            /* Zero out the seconds and microseconds so we don't block */

        tvptr.tv_sec = (long)(timeout / 1000);
        tvptr.tv_usec = (long)((timeout % 1000) * 1000);

            /* Initialize the read set to zero */

        FD_ZERO(&rset);

            /* And now turn on the read set */

        FD_SET(port,&rset);

        status = select(port + 1,&rset,NULL,NULL,&tvptr);

        if (status == -1) /* Error */
        {
            fprintf(stderr,"\nERROR:  dataready():  select() returned -1\n");
            perror( "select()" );
            rtnval = false;
        }
        else if (status > 0)
        {
            if (FD_ISSET(port,&rset))
            {
                rtnval = true;
            }
        }
    }
    return(rtnval);
}

/*!
  \param *dst ͂ꂽi[charϐւ̃|C^
  \return ꕶ͂łtrue
*/
bool posix_serial::read(char *dst)
{

    if (port != -1)
        return(::read(port,dst,1) == 1);
    else
        return false;
}

/*!
  \param src o͂镶
  \return ꕶo͂łtrue
*/
bool posix_serial::write(char src)
{
    if (port != -1)
        return(::write(port,&src,1) == 1);
    else
        return false;
}

/*!
  \param src o͂镶ւ̃|C^
  \return o͂ł
*/
int posix_serial::write_string(char *src)
{
    int rtnval = 0;

    if (src != (char *) NULL)
    {

        if (port != -1)
        {
            while (*src)
            {
                write(*src++);
                rtnval++;
            }
        }
    }
    return(rtnval);
}

