#include <stdio.h>
#include <string.h>
#include <setjmp.h>
#include <assert.h>

#include <kernel/kernel.h>
/// \defgroup RTOS_TASK ^XN̍쐬AAؑւ
/// \ingroup RTOS
//@{

static jmp_buf kernel_buf;         //<! J[l̃ReLXgobt@

//! ^XNRg[ubN
struct t_TCB
{
    void(*func)(int);             //<! ^XÑC֐
    int priority;                  //<! vCIeB(͎gpĂȂ)
    int stack_size;                //<! X^bNTCY
    void *stack_top;               //<! X^bN擪(ɂgpĂȂ)
    int state;                     //<! Xe[^X
    jmp_buf regs;                  //<! ReLXgobt@
};
static struct t_TCB tcb[MAXTASK];

//! ݎs̃^XNID
static int current_task_id = -1;

//! ݂̃^XN
static int current_num_of_tasks = 0;

static void *stack_length( int taskid );
static void expand_stack( int taskid );
static void create_task_stack( int taskid );
static void allocate_task_stack( int taskid );
static int next_resumed_task( int taskid );
static void create_task_stacks( void );
static void create_task( int taskid );

/*!
  ݂̃X^bNԂ
  @param taskid ^XNԍ
  @return ^XN̑傫(void *^)
*/
static void *stack_length( int taskid )
{
    void *current_stack;
    void *stack_start = tcb[taskid].stack_top;
// X^bN\ɈˑȂ悤AΒlvZĕԂ
    return(void *)(((void *)(&current_stack) < stack_start ) ?
                    ( stack_start -(void *)(&current_stack) ) :
                    ((void *)(&current_stack) - stack_start));
}

/*!
  X^bNL΂B
  @param taskid ^XNԍ
*/
static void expand_stack( int taskid )
{
    char nullbuf[16];
    memset( nullbuf, 0, 1 );     // œK΍
    allocate_task_stack( taskid );// returnɍċAďosB
}

/*!
  ^XN𐶐AX^bNmۂB
  @param taskid ^XNԍ
*/
static void create_task_stack( int taskid )
{
    void *stack_top;
    tcb[taskid].stack_top = &stack_top;  // X^bN擪(ʂ͂Ƃ傫Ԓn)ۑ
    create_task( taskid );              // ^XN̏ReLXgۑB
    allocate_task_stack( taskid );      // ꂼ̃^XÑX^bNmۂB
}

/*!
  ^XÑX^bNmۂ
  @param taskid ^XNԍ
*/
static void allocate_task_stack( int taskid )
{
    int stacksize =(int)stack_length( taskid );
    if( stacksize  < tcb[taskid].stack_size )
    {
        expand_stack( taskid );
        // ɂ͖߂ėȂBcreate_task_subċAĂяo邱ƂɂāA
        // X^bNL΂ĂB
        assert(0);
    }
    else
    {
        printf( "task %d created\n", taskid );
        taskid ++;
        if( taskid < current_num_of_tasks )
        {
            create_task_stack( taskid );
            // ɂ͖߂ėȂB
            assert(0);
        }
        longjmp( kernel_buf, TASK_CMD_SYSTEM_TASK_START );
        // ɂ͖߂ėȂB
        // J[l̃X^bNŌɎg邽߁A
        // J[lX^bN̊mۂ͕KvȂB
        assert(0);
    }
}

/*!
  ^XNɕAB
  @param taskid ^XNԍ
*/
static void return_to_task( int taskid )
{
    current_task_id = taskid;
    longjmp( tcb[taskid].regs,
             (TASK_CMD_SYSTEM_TASK_RETURNED << TASK_CMD_SHIFT_SIZE) | taskid );
}

/*!
  ̃ANeBu^XNIDTB
  ł͒PɎ̃^XNԂB
  @param taskid ݂̃^XNԍ
  @return ̃ANeBu^XNIDB}CiXȂSẴ^XNANeBu
*/
static int next_resumed_task( int taskid )
{
    taskid++;
    if( taskid >= current_num_of_tasks )
    {
        taskid = 0;
    }
    return taskid;
}

/*!
  o^ꂽSẴ^XN𐶐AX^bNmۂ
*/
static void create_task_stacks( void )
{
    create_task_stack( 0 );                // return ƃX^bN߂Ă܂B
}

/*!
  ^XN𐶐AReLXgobt@쐬B
  @param taskid ^XNԍ
*/
static void create_task( int taskid )
{
    int ret, t;
    ret = setjmp(tcb[taskid].regs);
    if( ret ==0 )
    {
        return; // ŏ̓X^bNmۂ邾
    }
    else if((ret >> TASK_CMD_SHIFT_SIZE) == TASK_CMD_SYSTEM_TASK_RETURNED )
    {
// return_to_taskŔł獡x^XNN
        t =(ret &((1 << TASK_CMD_SHIFT_SIZE)-1));
        tcb[t].func( t );
    }
    printf( "Task id %d finished", ret &((1 << TASK_CMD_SHIFT_SIZE)-1) );
// ɂ͗Ȃ͂B
    assert(0);
}
//@}

/*!
  ^XNJ[lɓo^
  @param taskfunc ^XÑC֐
  @param stacksize ^XNX^bN̑傫
  @param priority Dx(ݖgp)
*/
void register_task( void(*taskfunc)(int), int stacksize, int priority )
{
    tcb[current_num_of_tasks].stack_size = stacksize;
    tcb[current_num_of_tasks].func = taskfunc;
    tcb[current_num_of_tasks].priority = priority;
    current_num_of_tasks ++;
}

/*!
  ^XNؑւB
  ^XN炱̊֐𖾎IɌĂяoȂƃJ[lɐ䂪߂ȂB
*/
void yield_task( void )
{
    if( setjmp( tcb[current_task_id].regs ) == 0 )
    {
        longjmp( kernel_buf,(TASK_CMD_YIELD << TASK_CMD_SHIFT_SIZE) | current_task_id );
    }
}

/*!
 XPW[
*/
void scheduler(void)
{
    int ret, taskid;

// Œ̃^XNo^ĂKvB
    assert( current_num_of_tasks != 0 );
    ret = setjmp( kernel_buf );
    taskid =(ret &((1 << TASK_CMD_SHIFT_SIZE)-1));
    switch( ret >> TASK_CMD_SHIFT_SIZE )
    {
        case TASK_CMD_SYSTEM:
            switch( taskid )
            {
                case TASK_CMD_SYSTEM_TASK_CREATE:// ^XN𐶐B
                    create_task_stacks();
                    break;
                case TASK_CMD_SYSTEM_TASK_START:// X^bN𐶐炱ɖ߂ėB
                {
                    int i;
                    printf( "First Starting tasks %p\n", &i );
                    return_to_task(0);
                }
                    break;
                default:// ɂ͗Ȃ͂
                    assert(0);
            }
        case TASK_CMD_YIELD:// PȂ^XNXCb`BeXgpH
            taskid = next_resumed_task( taskid );
            if( taskid < 0 )
            {
                    // ŃX[vƂB
            }
            return_to_task( taskid );
            break;
        case TASK_CMD_SLEEP:
        case TASK_CMD_WAIT_MESSAGE:
        case TASK_CMD_WAIT_FLAG:
        case TASK_CMD_WAIT_SEMAPHORE:
            // ͂ɂ͗Ȃ͂B
            assert(0);
            break;
        default:
            // ɂ͗Ȃ͂            
            assert(0);
    }
}
