#ifndef __BIOS_API_H__
#define __BIOS_API_H__

/** \defgroup BIOS_API API
 * \brief APIĂяo
 *
 * APIĂяóA
 * \code
 *    int bios_call_api( int BIOS_NUM, int LPALAM, void *RPALAM )
 * \endcode
 * Ƃ`ōs܂BSĂAPIĂяo͂̊֐̕ʖłB
 * ĂяoAhX̓A[LeN`ˑłA
 * o[Wɂĕϓ邱Ƃ͂Ȃ̂Ƃ܂B
 *
 * Iɂ̓[U[AvP[VAPIĂяoɂ́A
 * ڌĂяoƃ\tgEFA荞݂̓̕@ōs܂B
 * 
 * ڌĂяȍꍇ́ABIOS͌ĂяoReLXgŎs邽߁A
 * ꍇɂĂ͂܂삵܂񂪁Aꕔ́A荞݂𒼐ڑ삷
 * 悤API͒ڌĂяoɂĂ̂݌ĂяoƂł܂B
 * 
 * Q̕@̑I͓APIŋK肷̂Ƃ܂A傫킯āA
 * 
 * - ReLXgɂČĂяo\bhύXAǂł삷
 * - 荞݋ReLXgŎsA\tgEFA荞݂ł삵Ȃ
 * - 荞݋֎~ReLXgŎsAڌĂяoł삵Ȃ
 * 
 * ܂B
 * 
 */
//@{

/// \defgroup BIOS_API_NUMBER APIԍ̒`
/// 
//@{
#define API_CALL_ADDRESS            (0x00000100)

#define API_REBOOT                  (0x01)
#define API_SHELL_GET_MODE          (0x11)
#define API_SHELL_SET_MODE          (0x12)
#define API_SHELL_COMMAND_ADD       (0x13)

#define API_INTERRUPT_STATUS        (0x21)
#define API_INTERRUPT_ENABLE        (0x22)
#define API_INTERRUPT_DISABLE       (0x23)
#define API_INTERRUPT_RESTORE       (0x24)
#define API_INTTERRUPT_SET_ENABLE   (0x27)
#define API_INTTERRUPT_SET_HANDLER  (0x28)

#define API_UART_INIT               (0x31)
#define API_UART_SET_TIMEOUT        (0x34)
#define API_UART_READ               (0x35)
#define API_UART_WRITE              (0x36)
#define API_UART_SET_READ_CALLBACK  (0x37)
#define API_UART_SET_WRITE_CALLBACK (0x38)

#define API_TIMER_INIT              (0x41)
#define API_TIMER_SET_CALLBACK      (0x42)

#define API_FLASH_WRITE             (0x51)

typedef int (*api_call_t)( int API_NUM, int LPARAM, void *RPARAM );
//@}

/// \defgroup BIOS_API_RETURN_VALUE BIOS̕Ԃl`
/// 
//@{
#define BIOS_NOERR                  ( 0   ) ///< I
#define BIOS_ERR                    ( -1  ) ///< ُI
#define BIOS_UNSUPPORTED_ERR        ( -2  ) ///< ُI(ΉAPI)
#define BIOS_PARAM_ERR              ( -4  ) ///< ُI(p[^ُ)

#define BIOS_UART_RCVCHAR_ERROR     ( -10 ) ///< 1MłȂ
#define BIOS_UART_SENDCHAR_ERROR    ( -11 ) ///< 1MłȂ
#define BIOS_UART_INVALID_PORT      ( -12 ) ///< ُȃ|[gw肵

#define BIOS_TIMER_NOT_EXIST        ( -20 ) ///< ^C}[݂Ȃ

#define BIOS_SHELL_NO_COMMAND_LIST  ( -97 ) ///< R}hXg݂Ȃ
#define BIOS_SHELL_INVALID_ARGS     ( -98 ) ///< VF̃p[^G[
#define BIOS_SHELL_INVALID_COMMAND  ( -99 ) ///< VF̃R}hG[
#define BIOS_SHELL_EXIT             (-100 ) ///< VFI

//@}

/** \defgroup CONFIG_API BIOSAPI
 * \brief BIOŜ̂̓Ɋ֘AAPIłB
 * 
 * API͏ɎAhXĂяoŎKv܂B
 */
//@{

/// SHELL[h
typedef enum {
    UART_SHELL_SINGLE,   ///< 荞݋֎~[hŃVFUART̓ǂݏs܂B
    UART_SHELL_MULTI,    ///< 荞݂gpăVFUART̓ǂݏs܂B
    UART_SHELL_GDB,       ///< ̓o͂VFHOOK܂B
    UART_DIRECT         ///< BIOSUART܂
} bios_shell_mode_t;

/** VFR}h\
 * VFŎsR}h`\́B
 */
typedef struct {
    char *name;                ///< R}h
    int (*func)(int, char **); ///< ֐
    char *help;                ///< R}h
} shell_command_list_t;


/// \brief ċN܂B
/// \param xLparam gp܂
/// \param xRparam gp܂
/// \return :BIOS_NOERR s:BIOS_ERR
#define bios_reboot( xLparam, xRparam )                      ((api_call_t)(API_CALL_ADDRESS))( API_BOOT_COLD, xLparam, xRparam )

/// \brief SHELL̓샂[h擾܂B
/// \param xLparam gp܂
/// \param xRparam gp܂
/// \return \bios_shell_mode_t Ŏw肳铮샂[h
#define bios_shell_mode_get( xLparam, xRparam )              ((api_call_t)(API_CALL_ADDRESS))( API_SHELL_GET_MODE, xLparam, xRparam )

/// \brief SHELL̓샂[hύX܂B
/// KvɉUART̏A荞݂̐ݒȂǂs܂B
/// \param xLparam \bios_shell_mode_t Ŏw肳铮샂[h
/// \param xRparam vvgւ̃|C^
/// \return :BIOS_NOERR s:BIOS_ERR
#define bios_shell_mode_set( xLparam, xRparam )              ((api_call_t)(API_CALL_ADDRESS))( API_SHELL_SET_MODE, xLparam, xRparam )

/// \brief SHELLɃR}hǉ܂B
/// \param xLparam gp܂
/// \param xRparam R}hXgւ̃|C^
/// \return :BIOS_NOERR s:BIOS_ERR
#define bios_shell_command_add( xLparam, xRparam )           ((api_call_t)(API_CALL_ADDRESS))( API_SHELL_COMMAND_ADD, xLparam, xRparam )

//@}

/** \defgroup INTERRUPT_API 荞API
 * \brief 荞݊֘Ȃs܂B
 * 
 * API͏ɎAhXĂяoŎKv܂B
 * 
 */
//@{

/// \brief 荞ݏԂ̎擾
/// \param xLparam gp܂
/// \param xRparam gp܂
/// \return 荞ݏ
#define bios_interrupt_status( xLparam, xRparam )        ((api_call_t)(API_CALL_ADDRESS))( API_INTERRUPT_STATUS, xLparam, xRparam )

/// \brief 荞݂
/// \param xLparam gp܂
/// \param xRparam gp܂
/// \return sO̊荞ݏ \ref bios_interrupt_restoreŕAƂɗp܂B
#define bios_interrupt_enable( xLparam, xRparam )        ((api_call_t)(API_CALL_ADDRESS))( API_INTERRUPT_ENABLE, xLparam, xRparam )

/// \brief 荞݂̋֎~
/// \param xLparam gp܂
/// \param xRparam gp܂
/// \return sO̊荞ݏ \ref bios_interrupt_restoreŕAƂɗp܂B
#define bios_interrupt_disable( xLparam, xRparam )       ((api_call_t)(API_CALL_ADDRESS))( API_INTERRUPT_DISABLE, xLparam, xRparam )

/// \brief 荞݂̕A
/// \param xLparam \ref bios_interrupt_enable ܂ \ref bios_interrupt_disable ŕۑꂽ
/// \param xRparam gp܂
/// \return :BIOS_NOERR s:BIOS_ERR
#define bios_interrupt_restore( xLparam, xRparam )       ((api_call_t)(API_CALL_ADDRESS))( API_INTERRUPT_RESTORE, xLparam, xRparam )

/// \brief 荞݃nh`
typedef void (*bios_interrupt_handler_t)(void);

/// \brief 荞݂̌ʋ/s
/// \param xLparam 荞ݔԍ
/// \param xRparam ƂĎgp 0:s 1:
/// \return :BIOS_NOERR s:BIOS_ERR
#define bios_interrupt_set_enable( xLparam, xRparam )    ((api_call_t)(API_CALL_ADDRESS))( API_INTERRUPT_SET_ENABLE, xLparam, xRparam )

/// \brief 荞݃nh̓o^
/// \param xLparam 荞ݔԍ
/// \param xRparam bios_interrupt_handler_t^̊荞݃nh
/// \return :BIOS_NOERR s:BIOS_ERR
#define bios_interrupt_set_handler( xLparam, xRparam )   ((api_call_t)(API_CALL_ADDRESS))( API_INTERRUPT_SET_HANDLER, xLparam, xRparam )

//@}

/** \defgroup UART_TIMER TIMERɊւAPI
 * \brief BIOSŎgp^C}[̐ݒs܂B
 *  1ms̃^C}񋟂A񋟏oȂꍇ̓G[Ԃ܂B
 */
//@{
/// \brief 
/// \param xLparam gp܂
/// \param xRparam gp܂
/// \return :BIOS_NOERR s:BIOS_ERR
#define bios_timer_init( xLparam, xRparam )               ((api_call_t)(API_CALL_ADDRESS))( API_TIMER_INIT, xLparam, xRparam )

/// \brief TimerR[obN֐`
typedef void (*bios_timer_callback_t)( void );

/// \brief R[obNo^
/// \param xLparam gp܂
/// \param xRparam bios_timer_callback_t^̃R[obN֐
/// \return :BIOS_NOERR s:BIOS_ERR
#define bios_timer_set_callback( xLparam, xRparam )       ((api_call_t)(API_CALL_ADDRESS))( API_TIMER_SET_CALLBACK, xLparam, xRparam )
//@}

/** \defgroup UART_API UARTɊւAPI
 * \brief UART̐ݒs܂B
 */
//@{
/// Xs[hB \ref bios_uart_param_t 8rbgɗ}邽߁A4ɌB
typedef enum { B9600,B38400,B57600,B115200 }             bios_uart_speed_t;

/// LN^̃rbg
typedef enum { CHAR_5BIT,CHAR_6BIT,CHAR_7BIT,CHAR_8BIT } bios_uart_length_t;

/// peB
typedef enum { PARITY_EVEN,PARITY_ODD,PARITY_NONE }      bios_uart_parity_t;

/// Xgbvrbg
typedef enum { STOPBIT_1,STOPBIT_15,STOPBIT_2}           bios_uart_stopbit_t;

/// UART
#define UART_STATUS_NO_ERROR          0
#define UART_STATUS_FRAME_ERROR       1
#define UART_STATUS_PARITY_ERROR      2
#define UART_STATUS_OVERFLOW_ERROR    4
#define UART_STATUS_BREAK             8

/// \ref bios_uart_initŗp\́B
typedef struct
{
    bios_uart_speed_t speed     : 2; ///< Xs[h
    bios_uart_length_t length   : 2; ///< LN^
    bios_uart_parity_t parity   : 2; ///< peB
    bios_uart_stopbit_t stopbit : 2; ///< Xgbvrbg
} bios_uart_param_t;

/// \ref bios_uart_set_timeout ŗp\
typedef struct
{
    int read_timeout;  ///<@ǂݏo^CAEg(ms) -1Ŗɑ҂
    int write_timeout; ///<@݃^CAEg(ms) -1Ŗɑ҂
} bios_uart_timeout_t;

/// \ref bios_uart_read A\ref bios_uart_write ŗp\
typedef struct
{
    int length;    ///< ǂݏő咷
    char *buffer;  ///< ǂݏobt@
} bios_uart_buffer_t;


/// \brief UARTR[obN֐`
typedef int (*bios_uart_callback_t)(bios_uart_buffer_t *buffer);

/// \brief 
/// \param xLparam |[gԍ
/// \param xRparam \ref bios_uart_param_t *^̃p[^
/// \return :BIOS_NOERR s:BIOS_ERR
#define bios_uart_init( xLparam, xRparam )               ((api_call_t)(API_CALL_ADDRESS))( API_UART_INIT, xLparam, xRparam )

/// \brief ^CAEgw
/// \param xLparam |[gԍ
/// \param xRparam \ref bios_uart_timeout_t *^̃p[^
/// \return :BIOS_NOERR s:BIOS_ERR
#define bios_uart_set_timeout( xLparam, xRparam )        ((api_call_t)(API_CALL_ADDRESS))( API_UART_SET_TIMEOUT, xLparam, xRparam )

/// \brief woCgǏo
/// \param xLparam |[gԍ
/// \param xRparam \ref bios_uart_buffer_t *^̃p[^
/// \return :BIOS_NOERR s:BIOS_ERR
#define bios_uart_read( xLparam, xRparam )               ((api_call_t)(API_CALL_ADDRESS))( API_UART_READ, xLparam, xRparam )

/// \brief woCg
/// \param xLparam |[gԍ
/// \param xRparam \ref bios_uart_buffer_t *^̃p[^
/// \return :BIOS_NOERR s:BIOS_ERR
#define bios_uart_write( xLparam, xRparam )              ((api_call_t)(API_CALL_ADDRESS))( API_UART_WRITE, xLparam, xRparam )

/// \brief woCgǏopR[obNݒ
/// \param xLparam |[gԍ
/// \param xRparam \ref bios_uart_callback_t ^̃R[obN֐
/// \return :BIOS_NOERR s:BIOS_ERR
#define bios_uart_set_read_callback( xLparam, xRparam )  ((api_call_t)(API_CALL_ADDRESS))( API_UART_SET_READ_CALLBACK, xLparam, xRparam )

/// \brief woCgpR[obNݒ
/// \param xLparam |[gԍ
/// \param xRparam \ref bios_uart_callback_t ^̃R[obN֐
/// \return :BIOS_NOERR s:BIOS_ERR
#define bios_uart_set_write_callback( xLparam, xRparam ) ((api_call_t)(API_CALL_ADDRESS))( API_UART_SET_WRITE_CALLBACK, xLparam, xRparam )
//@}

/** \defgroup FLASH_API FLASHROMɊւAPI
 * FLASHROM̏AA݂s܂B
 * FLASHROMɊւĂ̓vbgz[ˑ߁AAPIƂẮAAPIpӂ܂B 
 *
 * APÍAKvȗ̈̏sA݂s܂BBIOS̈邱Ƃ\Ƃ܂A
 * ̏ꍇ͕̌̓słBŃZbgłA[LeN`ł́AZbgsׂł傤B
 */
//@{
/// FLASHݗp̍\
typedef struct
{
    void *destination;    ///< ݐAhX
    void *source;         ///< ݌f[^
    int length;           ///< f[^(oCgP)
} bios_flash_param_t;

/// \brief FLASH
/// \param xLparam ݌̏ 0:̂܂ܖ߂ 1:u[g
/// \param xRparam \ref bios_flash_param_t *^̃p[^
/// \return :BIOS_NOERR s:BIOS_ERR
#define bios_flash_write( xLparam, xRparam )             ((api_call_t)(API_CALL_ADDRESS))( API_FLASH_WRITE, xLparam, xRparam )

//@}

//@}

#endif /*__BIOS_API_H__*/
