#include <drivers.h>
#include <plathome.h>
#include <shell/xmodem.h>
#include <shell/shell_string.h>
#include <shell/shell_uart.h>

//------------------------------------------------
// ֐vg^Cv(wlncdlp)
//------------------------------------------------
static int xmodem_receive_char(unsigned char* ch, int timeout);

#define GET_OK      (0)
#define GET_NG      (-1)
//-----------------------------------
// ꕶ̒`
//-----------------------------------
#define NAK		'\x15'             // Mv(XMODEM)
#define SOH		'\x01'             // 128oCgpPbg/ubNwb_
#define ACK		'\x06'             // m艞
#define EOT		'\x04'             // MI
#define CAN		'\x18'             // LZ

//-----------------------------------
// XMODEMp staticϐ
//-----------------------------------
static unsigned char recv_buffer[XMODEM_BLOCK_SIZE]; //< Mobt@

/// \brief xmodem 1BlockM
/// \return  0!=ʏI(̏݃擪AhX 0=EOTM(buf̓e͖)
int xmodem_receive( void (*get_data_callback)( int block_no, unsigned char *buffer ) )
{
    int i;
    unsigned char ch, blk, rblk,chksum;
    unsigned char* buf;
    int s_blkseq = 0;  // ݂̃ubNԍ(0`255)
    int flag = 0;

    // Mł܂Ń[v
    // continue,return 0, return 1ŒEo; 炵AƂ肠
    while (1)
    {
        int counter = 0;
            // wb_҂(Ƃ肠ivɑ҂)
        buf = recv_buffer;
        do
        {
            if(flag == 1)
            {
                ch = shell_getc();
            }
            else
            {
                s_blkseq = 1;
                while (xmodem_receive_char(&ch, 10) == GET_NG)
                { /* while(time out) */
                    shell_putc(NAK);        /* NAKM*/
                }
                flag = 1;
            }
            if (ch == EOT)
            {
                if (xmodem_receive_char(&ch, 10) == GET_NG)
                { //@{EOT͎̃oCg͎MȂ
                    shell_putc(ACK);
                    return s_blkseq * XMODEM_BLOCK_SIZE; //t@CM
                }
            }
        } while((ch != SOH) && (counter++ < 10) );
        
        /* blkM */
        if((xmodem_receive_char(&blk, 1000) != GET_OK) || (blk > (s_blkseq&0xff)))
        {
            /* ݂܂ł̃V[PXԍƈႤƂNAKĂ蒼*/
            shell_putc(NAK);
            continue;
        }
            
        /* (rblk=~blk)M */
        if(( xmodem_receive_char(&rblk, 1000) != GET_OK) || (rblk != (unsigned char)~blk))
        {
            shell_putc(NAK);
            continue;
        }
        
        chksum = 0;
        if(blk == (s_blkseq&0xff))
        {
            /* f[^M */
            for(i = 0; i < XMODEM_BLOCK_SIZE; i++)
            {
                if( xmodem_receive_char(buf, 1000) != GET_OK)
                {
                    i = 999;
                }
                chksum += *buf++;
            }
            if(i == 1000)
            {
                shell_putc(NAK);
                continue;
            }
            /* `FbNTƍ */
            if(( xmodem_receive_char(&ch, 1000) == GET_OK) && (ch == chksum))
            {
                /* MR[obNĂяo */
                get_data_callback( s_blkseq, recv_buffer );
                /* ACKM */
                shell_putc(ACK);
                s_blkseq++;
                continue;   /* 1block MA */
            }
            else
            {
                shell_putc(NAK);
                /* continue; */
            }
        }
        else
        {
            /* ɎMς݂̃ubNȂ̂ŏ݂͂Ȃ */
            /* f[^M */
             for(i = 0; i < XMODEM_BLOCK_SIZE; i++)
             {
                 if( xmodem_receive_char(&ch, 1000) != GET_OK)
                 {
                     i = 999;
                 }
                 chksum += ch;
            }
            if(i == 1000)
            {
                shell_putc(NAK);
                continue;
            }
            /* `FbNTƍ */
            if(( xmodem_receive_char(&ch, 1000) == GET_OK) && (ch == chksum))
            {
                /* ACKM */
                shell_putc(ACK);
                /* continue; */
            }
            else
            {
                shell_putc(NAK);
                /* continue; */
            }
        }
    }
}

/// ^CAEgt
static int xmodem_receive_char(unsigned char* ch, int timeout)
{
    unsigned long i;
    for( i = 0; i < (UART_CHECK_COUNT_1MS * timeout); i++ )
    {
        if ( _uart_rx_ready( SHELL_UART_PORT ) )
        {
            *ch = _uart_getc( SHELL_UART_PORT );
            return GET_OK;
        }
    }
    return GET_NG;
}
