#include <string.h>
#include <bios_api.h>
#include <plathome.h>

#include <shell/shell_string.h>
#include <shell/shell_printf.h>
#include <shell/command.h>

/// wv
static int help( shell_command_list_t *command_table )
{
    int i = 0;
    while ( command_table[i].func )
    {
        i++;
    }
    if ( command_table[i].name )
    {
        shell_printf( "%s\twv\n", command_table[i].name );
    }
    else
    {
        shell_printf( "wv\n" );
    }
    
    i = 0;
    while ( command_table[i].func )
    {
        shell_printf( "%s\t\t%s\n",
                      command_table[i].name,
                      command_table[i].help );
        i++;
    }
    return BIOS_NOERR;
}

int exec_command( shell_command_list_t *command_table, int argc, char **argv )
{
    int i = 0;
    if ( argc == 0 )
    {
        help( command_table );
        return BIOS_NOERR;
    }

    while ( command_table[i].func )
    {
        if ( !strcmp( command_table[i].name, *argv ) )
        {
            return (command_table[i].func)(argc, argv);
        }
        i++;
    }
    if ( !strcmp( "help", *argv ) )
    {
        help( command_table );
        return BIOS_NOERR;
    }
    return BIOS_SHELL_INVALID_COMMAND;
}
