/* original http://plamo.linet.gr.jp/~mituiwa/3664dev.tar.gz */
OUTPUT_ARCH(h8300hn)
ENTRY("__start")
MEMORY
{
	vectors : o = 0x0000, l = 0x0034
	rom     : o = 0x0034, l = 0x7fcc
	ram     : o = 0xf780, l = 0x0800
	stack   : o = 0xff80, l = 0x0004
}
SECTIONS
{
.vectors : {
	/* Use something like this to place a specific function's address
	   into the vector table.  */
	SHORT(ABSOLUTE(__start))	/*  Reset vector */
	SHORT(ABSOLUTE(__int_default))	/*  Reserved */
	SHORT(ABSOLUTE(__int_default))	/*  Reserved */
	SHORT(ABSOLUTE(__int_default))	/*  Reserved */
	SHORT(ABSOLUTE(__int_default))	/*  Reserved */
	SHORT(ABSOLUTE(__int_default))	/*  Reserved */
	SHORT(ABSOLUTE(__int_default))	/*  Reserved */
	SHORT(DEFINED(int07)?ABSOLUTE(int07):ABSOLUTE(__int_default))
	SHORT(DEFINED(int08)?ABSOLUTE(int08):ABSOLUTE(__int_default))
	SHORT(DEFINED(int09)?ABSOLUTE(int09):ABSOLUTE(__int_default))
	SHORT(DEFINED(int0a)?ABSOLUTE(int0a):ABSOLUTE(__int_default))
	SHORT(DEFINED(int0b)?ABSOLUTE(int0b):ABSOLUTE(__int_default))
	SHORT(DEFINED(int0c)?ABSOLUTE(int0c):ABSOLUTE(__int_default))
	SHORT(DEFINED(int0d)?ABSOLUTE(int0d):ABSOLUTE(__int_default))
	SHORT(DEFINED(int0e)?ABSOLUTE(int0e):ABSOLUTE(__int_default))
	SHORT(DEFINED(int0f)?ABSOLUTE(int0f):ABSOLUTE(__int_default))
	SHORT(DEFINED(int10)?ABSOLUTE(int10):ABSOLUTE(__int_default))
	SHORT(DEFINED(int11)?ABSOLUTE(int11):ABSOLUTE(__int_default))
	SHORT(DEFINED(int12)?ABSOLUTE(int12):ABSOLUTE(__int_default))
	SHORT(DEFINED(int13)?ABSOLUTE(int13):ABSOLUTE(__int_default))
	SHORT(ABSOLUTE(__int_default))	/*  Reserved */
	SHORT(DEFINED(int15)?ABSOLUTE(int15):ABSOLUTE(__int_default))
	SHORT(DEFINED(int16)?ABSOLUTE(int16):ABSOLUTE(__int_default))
	SHORT(DEFINED(int17)?ABSOLUTE(int17):ABSOLUTE(__int_default))
	SHORT(DEFINED(int18)?ABSOLUTE(int18):ABSOLUTE(__int_default))
	SHORT(DEFINED(int19)?ABSOLUTE(int19):ABSOLUTE(__int_default))
        }  > vectors
.text 0x0034 : {
	*(.text)
	*(.strings)
	*(.rodata*)
   	 _etext = .;
	} > rom
.tors : {
	___ctors = .;
	*(.ctors)
	___ctors_end = .;
	___dtors = . ;
	*(.dtors)
	___dtors_end = .;
	}  > rom
.data : AT ( ADDR(.tors) + SIZEOF(.tors)){
	___data = .;
	*(.data)
	*(.tiny)
	 _edata = .;
	} > ram
	data_size = SIZEOF(.data);
.bss :  {
	 _bss_start = . ;
	*(.bss)
	*(COMMON)
	 _end = . ;
	}  > ram
	bss_size = SIZEOF(.bss);  
.stack : {
	 _stack = . ; 
	*(.stack)
	}  > stack
p.stab 0 (NOLOAD) : {
	[ .stab ]
	}
.stabstr 0 (NOLOAD) : {
	[ .stabstr ]
	}
}
