#include <h8_3069f/h8_3069f.h>
#include <string.h>
#include <bios_api.h>
#include <internal_api.h>
#include <plathome.h>

#include <shell/shell_uart.h>
#include <shell/shell_string.h>
#include <shell/shell_printf.h>

#include <shell/command.h>

static int test( int argc, char **argv );
static int timertest( int argc, char **argv );
static int flashtest( int argc, char **argv );

static shell_command_list_t const internal_command_table[] =
{
    { "test",      test,      "eXgR}h" },
    { "timertest", timertest, "TimereXg" },
    { "flashtest", flashtest, "FlasheXg" },
    { "extR}h",0,0 }
};

static void testhandler( void )
{
    shell_printf( "Interrupt test\r\n" );
}

static int test( int argc, char **argv )
{
    _interrupt_enable();
    _interrupt_enable_num( INTERRUPT_AKI_H8_3069_NMI );
    _interrupt_set_handler( INTERRUPT_AKI_H8_3069_NMI, (bios_interrupt_handler_t)testhandler );

    shell_printf( "test command \n" );
    shell_printf( "(10i) %d\n", 10 );
    shell_printf( "(16i) %x\n", 10 );
    return BIOS_NOERR;
}

static void timertesthandler( void )
{
    static int count1 = 0, count2 = 0;

    if ( REGISTER( T83_BASE, T8CSR ) & T8CSR_CMFA )
    {
        if ( ++count1 >= 25 )
        {
            if ( ++count2 >= 1000 )
            {
                shell_printf( "Timer test\r\n" );
                count2 = 0;
            }
            count1 = 0;
        }
        REGISTER( T83_BASE, T8CSR ) = ~T8CSR_CMFA;
    }
}

static int timertest( int argc, char **argv )
{
    _interrupt_enable();
    _interrupt_enable_num( INTERRUPT_AKI_H8_3069_CMIAB3 );
    _interrupt_set_handler( INTERRUPT_AKI_H8_3069_CMIAB3, (bios_interrupt_handler_t)timertesthandler );
    REGISTER( T83_BASE, TCORA ) = 125;
    REGISTER( T83_BASE, T8CR ) = T8CR_CMIEA | T8CR_CCLR0 | T8CR_CKS0;

    return BIOS_NOERR;
}

int flash_copy( unsigned long source,  unsigned long destination, int length, int verbose, int reboot );
static int flashtest( int argc, char **argv )
{
    int rval;
    _interrupt_disable();
    shell_printf( "%8.8X\n", (unsigned long)flash_copy );
    rval = flash_copy( 0x400000,  0x20000, 0x1000, 1, 0 );
    shell_printf( "%8.8X\n", rval );
    return BIOS_NOERR;
}

int exec_extra_command( int argc, char **argv )
{
    return exec_command( (shell_command_list_t *)internal_command_table, argc, argv );
}
