#include <h8_3069f/h8_3069f.h>

#include <drivers.h>

unsigned long const ports[3] = 
{
    SCI0_BASE,
    SCI1_BASE,
    SCI2_BASE
};
    
int _aki_h8_3069_uart_init( int port, bios_uart_param_t *params )
{
    unsigned char mode = 0;
    
    if ( params == 0 )
    {
    }
    else
    {
        
        switch( params->length )
        {
            case CHAR_5BIT: break; // Unsupported
            case CHAR_6BIT: break; // Unsupported
            case CHAR_7BIT: mode &= ~SMR_CHR; break; 
            case CHAR_8BIT: mode |= SMR_CHR;  break; 
        }
        
        switch( params->parity )
        {
            case PARITY_EVEN: mode |= SMR_PE; mode |= SMR_OE; break;
            case PARITY_ODD:  mode |= SMR_PE; mode &=~SMR_OE; break;
            case PARITY_NONE: mode |=~SMR_PE; break;
        }
        
        switch( params->stopbit )
        {
            case STOPBIT_1:  mode &=~SMR_STOP; break;
            case STOPBIT_15: break; // Unsupported
            case STOPBIT_2:  mode |= SMR_STOP; break;
        }

    }
    *(volatile unsigned char *)(ports[port] + SMR) = mode;
    if ( params == 0 )
    {
        mode = 6;
    }
    else
    {
        switch( params->speed )
        {
            case B9600:   mode = 80; break;
            case B38400:  mode = 19; break;
            case B57600:  mode = 12; break;
            case B115200: mode = 6;  break;
        }
    }

    REGISTER( ports[port],  BRR ) = mode;
    for( mode = 250 ; mode > 0 ; mode--) ;	/* Wait 1bit transfer time	    */
    REGISTER( ports[port],  SSR ) &= 0x80; // Clear receive error rflag(ORER,FER,PER)
    REGISTER( ports[port],  SCR ) = 0x30;  // Enable Tx and Rx. Interrupt Disable now.
    
    return BIOS_NOERR;
}

int _aki_h8_3069_uart_rx_ready( int port )
{
	return REGISTER( ports[port],  SSR ) & SSR_RDRF;
}

int _aki_h8_3069_uart_tx_ready( int port )
{
	return REGISTER( ports[port],  SSR ) & SSR_TDRE;
}

int _aki_h8_3069_uart_getc( int port )
{
    int c;

// G[`FbNBׂ݂͂Ė

    if ( REGISTER( ports[port],  SSR ) & SSR_ORER )
    {
        REGISTER( ports[port],  SSR ) &= ~SSR_ORER;
    }
    if ( REGISTER( ports[port],  SSR ) & SSR_FER )
    {
        REGISTER( ports[port],  SSR ) &= ~SSR_FER;
    }
    if ( REGISTER( ports[port],  SSR ) & SSR_PER )
    {
        REGISTER( ports[port],  SSR ) &= ~SSR_PER;
    }

    if ( REGISTER( ports[port],  SSR ) & SSR_RDRF)
    {
        c = REGISTER( ports[port],  RDR );
        REGISTER( ports[port],  SSR ) &= ~SSR_RDRF;
        return c;
    }
    return BIOS_UART_RCVCHAR_ERROR;
}

int _aki_h8_3069_uart_putc( int port, unsigned char c )
{
    if (REGISTER( ports[port],  SSR ) & SSR_TDRE)
    {
        REGISTER( ports[port],  TDR )  = c;
        REGISTER( ports[port],  SSR ) &= ~SSR_TDRE;
        return BIOS_NOERR;
    }
    return BIOS_UART_SENDCHAR_ERROR;
}

int _aki_h8_3069_uart_interrupt_enable( int port )
{
    return BIOS_NOERR;
}

int _aki_h8_3069_uart_interrupt_disable( int port )
{
    return BIOS_NOERR;
}

int _aki_h8_3069_uart_send_interrupt_enabled( int port )
{
    return BIOS_NOERR;
}

int _aki_h8_3069_uart_send_interrupt_enable( int port )
{
    return BIOS_NOERR;
}

int _aki_h8_3069_uart_send_interrupt_disable( int port )
{
    return BIOS_NOERR;
}

int _aki_h8_3069_uart_recv_interrupt_enabled( int port )
{
    return BIOS_NOERR;
}

int _aki_h8_3069_uart_recv_interrupt_enable( int port )
{
    return BIOS_NOERR;
}

int _aki_h8_3069_uart_recv_interrupt_disable( int port )
{
    return BIOS_NOERR;
}

