CPU_ARCH  = h8300
SYS_TYPE  = elf
ARCH_PREFIX = $(CPU_ARCH)-$(SYS_TYPE)-

EXTRAASFLAGS  = -mrelax -mint32 -mh -I$(BUILD_ROOT)/include -I$(BUILD_ROOT)/$(ARCH) -I$(BUILD_ROOT)/$(ARCH)/include -I $(BUILD_ROOT)/bios -I $(BUILD_ROOT)/bios/include
EXTRACFLAGS   = $(EXTRAASFLAGS)
EXTRACXXFLAGS = $(EXTRACFLAGS)
EXTRALFLAGS   = -mh -nostartfiles -Wl,-Map,$(basename $(TARGET)).map -Wl,-T$(ARCH)/h83069.x

ASFLAGS  = -Werror -Wall -I $(BUILD_ROOT) $(EXTRAASFLAGS)
CFLAGS   = -Werror -Wstrict-prototypes -Winline -Wundef -Wall -Os -I $(BUILD_ROOT) $(EXTRACFLAGS)
CXXFLAGS = -Werror -Wno-deprecated -Wstrict-prototypes -Winline -Wundef -Wall -Os -I $(BUILD_ROOT) $(EXTRACXXFLAGS)
LFLAGS = $(EXTRALFLAGS)

# ^[Qbgst@CoCit@Cɕϊ
SRECORD= $(basename $(TARGET)).sre
postmake: $(SRECORD)

$(SRECORD): $(TARGET)
ifeq ($(ROOT_IS_THIS), TRUE)
	$(ARCH_PREFIX)objcopy -O srec --set-start 0 $(TARGET) $(SRECORD)
endif

# cleanɃoCit@Cǉ
clean: ihexclean
.PHONY: ihexclean
ihexclean:
	@rm -f $(SRECORD)
