/*-------------------------------------*/
/* Peripheral Identifier and Interrupt */
/*-------------------------------------*/

#define FIQ_ID          0       /* Fast Interrupt */
#define SWIRQ_ID        1       /* Soft Interrupt (generated by the AIC) */
#define US0_ID          2       /* USART Channel 0 interrupt */
#define US1_ID          3       /* USART Channel 1 interrupt */
#define TC0_ID          4       /* Timer Channel 0 interrupt */
#define TC1_ID          5       /* Timer Channel 1 interrupt */
#define TC2_ID          6       /* Timer Channel 2 interrupt */
#define WDI_ID          7       /* Watchdog interrupt */
#define PIO_ID          8       /* Parallel I/O Controller A interrupt */

#define IRQ0_ID         16      /* External interrupt 0 */
#define IRQ1_ID         17      /* External interrupt 1 */
#define IRQ2_ID         18      /* External interrupt 2 */

/*-----------------------*/
/* Peripheral Memory Map */
/*-----------------------*/

#define WD_BASE             ((StructWD*)0xFFFF8000)  /* WD: Watchdog Timer Base Address */
#define PIO_BASE            ((StructPIO*)0xFFFF0000) /* Parallel I/O Controller Base Address  */
#define USART1_BASE         ((StructUSART*)0xFFFCC000)      /* USART 1 Base Address */
#define USART0_BASE         ((StructUSART*)0xFFFD0000)      /* USART 0 Base Address */

/* Timer Counter Base Addresses */
#define TCB0_BASE           ((StructTCBlock*)0xFFFE0000)
#define TC0_BASE            ((StructTC *)0xFFFE0000)
#define TC1_BASE            ((StructTC *)0xFFFE0040)
#define TC2_BASE            ((StructTC *)0xFFFE0080)

/*-------------------------*/
/* Internal RAM Definition */
/*-------------------------*/

#define RAM_SIZE        (8*1024)
#define RAM_BASE        ((u_int *)0x00000000)
#define RAM_LIMIT       (((u_int)RAM_BASE) + RAM_SIZE)


/* The internal RAM is mapped at address 0x00300000 after reset until
   Remap command is performed on the EBI. */

#define RAM_BASE_BOOT   ((u_int *)0x00300000)

/*----------*/
/* ARM Core */
/*----------*/
#include    "arm.h"

/*----------------------------*/
/* Special Function Registers */
/*----------------------------*/
#include    "sf.h"

/*------------------------*/
/* External Bus Interface */
/*------------------------*/
#include    "ebi.h"

/*--------------------------*/
/* Power Saving Controller  */
/*--------------------------*/
#include    "ps.h"

/*-------------------------------*/
/* Advanced Interrupt Controller */
/*-------------------------------*/

#include    "aic.h"

/*-------------------------*/
/* Parallel I/O Controller */
/*-------------------------*/
#include    "pio_single.h"
#include    "pio.h"

#define NB_PIO          31          /* Number of PIO Lines */

/*------------------*/
/* Pin Multiplexing */
/*------------------*/
/* PIO Controller  */

#define PIOTCLK0        0x1         /* Timer 0 Clock signal */
#define PIOTIOA0        0x2        /* Timer 0 Signal A */
#define PIOTIOB0        0x4        /* Timer 0 Signal B */

#define PIOTCLK1        0x8        /* Timer 1 Clock signal  */
#define PIOTIOA1        0x10       /* Timer 1 Signal A */
#define PIOTIOB1        0x20       /* Timer 1 Signal B */

#define PIOTCLK2        0x40       /* Timer 2 Clock signal input */
#define PIOTIOA2        0x80       /* Timer 2 Signal A */
#define PIOTIOB2        0x100      /* Timer 2 Signal B */

#define PIOIRQ0         0x200      /* External Interrupt 0 */
#define PIOIRQ1         0x400      /* External Interrupt 1 */
#define PIOIRQ2         0x800      /* External Interrupt 2 */
#define PIOFIQ          0x1000     /* Fast Interrupt input */

#define PIOSCK0         0x2000     /* USART 0 clock signal */
#define PIOTXD0         0x4000     /* USART 0 transmit data signal */
#define PIORXD0         0x8000     /* USART 0 receive data signal */

#define PIOSCK1         0x100000   /* USART 1 clock signal */
#define PIOTXD1         0x200000   /* USART 1 transmit data signal */
#define PIORXD1         0x400000   /* USART 1 receive data signal */

#define PIOMCK0         0x2000000  /* Master Clock Output */
#define PIONCS2         0x4000000  /* Chip Select 2 */
#define PIONCS3         0x8000000  /* Chip Select 3 */
#define PIOCS7          0x10000000 /* Address 20/Chip Select 7 */
#define PIOCS6          0x20000000 /* Address 21/Chip Select 6 */
#define PIOCS5          0x40000000 /* Address 22/Chip Select 5 */
#define PIOCS4          0x80000000 /* Address 23/Chip Select 4 */

/*--------*/
/* USARTs */
/*--------*/
/* Definition file */
#include    "usart.h"

/*----------*/
/* Watchdog */
/*----------*/
/* Definition file */
#include    "wd.h"

/*---------------*/
/* Timer Counter */
/*---------------*/
#include    "tc.h"
