/*--------------------------------------------------*/
/* Power Saving User Interface Structure Definition */
/*--------------------------------------------------*/
typedef struct
{
    at91_reg    PS_CR ;     /* Control Register */
    at91_reg    PS_PCER ;   /* Peripheral Clock Enable Register */
    at91_reg    PS_PCDR ;   /* Peripheral Clock Disable Register */
    at91_reg    PS_PCSR ;   /* Peripheral Clock Status Register */
} StructPS ;

/*-------------------------------------------------------*/
/* PS_CR : Power Saving Control Register Bits definition */
/*-------------------------------------------------------*/

#define PS_ARM7DIS          0x1

/*------------------------------------------------------------*/
/* PS_PCxR : Power Saving Peipheral Registers Bits definition */
/*------------------------------------------------------------*/

#define PS_USART0          0x4
#define PS_USART1          0x8
#define PS_TIMER0          0x10
#define PS_TIMER1          0x20
#define PS_TIMER2          0x40
#define PS_PIO             0x100

/*---------------------------*/
/* Power Saving Base Address */
/*---------------------------*/

#define PS_BASE         (( StructPS *) 0xFFFF4000)
