#include <at91/reg_r40807.h>
#include <bios_api.h>

#include <internal_api.h>

unsigned long private_vector_table[4];

#define ARM_AT91X40_INTERRUPT_FIQ      (0)
#define ARM_AT91X40_INTERRUPT_SWIRQ    (1)
#define ARM_AT91X40_INTERRUPT_US0IRQ   (2)
#define ARM_AT91X40_INTERRUPT_US1IRQ   (3)
#define ARM_AT91X40_INTERRUPT_TC0IRQ   (4)
#define ARM_AT91X40_INTERRUPT_TC2IRQ   (5)
#define ARM_AT91X40_INTERRUPT_WDIRQ    (7)
#define ARM_AT91X40_INTERRUPT_PIOIRQ   (8)
#define ARM_AT91X40_INTERRUPT_IRQ0     (16)
#define ARM_AT91X40_INTERRUPT_IRQ1     (17)
#define ARM_AT91X40_INTERRUPT_IRQ2     (18)


int _aki_arm7_bios_call_api_swi(  volatile int API_NUM, volatile int LPARAM, volatile void *RPARAM )
{
    return BIOS_NOERR;
}


void default_irq_handler( void ) __attribute__ ((interrupt("IRQ")));


void default_irq_handler( void )
{
    volatile int num = AIC_ISR & 0x1f;
	AIC_ICCR = 1 << num;
    ((bios_interrupt_handler_t)(AIC_IVR))();
	AIC_EOICR = 1;
}

void undefined_handler( void ) __attribute__ ((interrupt("UNDEF")));
void data_abort_handler( void ) __attribute__ ((interrupt("ABORT")));
void prefetch_abort_handler( void ) __attribute__ ((interrupt("ABORT")));
void swi_handler( void ) __attribute__ ((interrupt("SWI")));

void undefined_handler( void )
{}

void swi_handler( void )
{}

void prefetch_abort_handler( void )
{}

void data_abort_handler( void )
{}

int _aki_arm7_interrupt_status( void )
{
    int status=0;
    asm volatile( "mrs	%0, cpsr\n\t" : "+r"(status) );
    return status;
}

int _aki_arm7_interrupt_enable( void )
{
    int status=0, tmp=0;
    asm volatile( "mrs	%0, cpsr\n\t"
                  "bic			%1, %0, #0xC0\n\t"
                  "msr			cpsr_c, %1\n"
                  : "+r"(status), "+r"(tmp) );
    return status;
}

int _aki_arm7_interrupt_disable( void )
{
    int status=0, tmp=0;
    asm volatile( "mrs	%0, cpsr\n\t"
                  "orr			%1, %0, #0xC0\n\t"
                  "msr			cpsr_c, %1\n"
                  : "+r"(status), "+r"(tmp) );
    return status;
}

void _aki_arm7_interrupt_restore( int status )
{
    asm volatile( "msr			cpsr_c, %0\n" : "+r"(status) );
}

int _aki_arm7_interrupt_enable_num( int number )
{
    AIC_IECR = 1 << number;
    AIC_ICCR = 1 << number;
    AIC_BASE->AIC_SMR[ number ] = AIC_SRCTYPE_EXT_POSITIVE_EDGE;
    return BIOS_NOERR;
}

int _aki_arm7_interrupt_disable_num( int number )
{
    AIC_IDCR = 1 << number;
    return BIOS_NOERR;
}

int _aki_arm7_interrupt_set_handler( int number, bios_interrupt_handler_t handler )
{
    AIC_BASE->AIC_SVR[ number ] = (at91_reg)handler;
    return BIOS_NOERR;
}

int _aki_arm7_interrupt_set_timer_handler( int timerid, bios_interrupt_handler_t handler )
{
    return BIOS_NOERR;
}
