# -*- coding: Shift_JIS -*-

require 'zlib'
require 'kconv'
require 'Win32API'

scripts = []
File.open('data/Scripts.rvdata2', "rb") do |f|
  scripts = Marshal.load(f)
end

script_count = 1
dir_count = 1
output_dir = ''
scripts.each() do |sec|
  name = sec[1].tosjis
  data = sec[2]
  if name.nil?
    next
  end
  if name =~ /^/
    output_dir = 'tmp/' + "%02d." % dir_count + name
    unless FileTest.directory?(output_dir)
      Dir.mkdir(output_dir)
    end
    dir_count += 1
    script_count = 1
  end
  if name =~ /^[A-Za-z0-9]+/
    File.open(output_dir + '/%02d.' % script_count + name + '.rb', "wb+") do |f|
      f.write(Zlib::Inflate.inflate(data).tosjis)
    end
    script_count += 1
  end
end
