package jp.co.ase.izpack.util;

import java.util.regex.Pattern;

import com.izforge.izpack.panels.ProcessingClient;
import com.izforge.izpack.panels.Validator;

/**
 * Windows Service Name Check
 *
 * @author hk00319
 *
 */
public class WindowsServiceValidator implements Validator {

	/**
	 * Windows Service Name validator
	 */
	public boolean validate(ProcessingClient client) {
		String serviceName = client.getText();
		boolean isEmpty = false;
		if ((serviceName == null) || (serviceName.length() == 0)) {
			isEmpty = true;
		}

		boolean existService = WindowsUtils.existService(serviceName);

		// 半角の英数字、_(アンダーバー) 、-(ハイフン) で50バイトまでOK
		Pattern pattern = Pattern.compile("[a-zA-Z0-9\\-\\_]{1,50}");
		boolean isNumNumeric = pattern.matcher(serviceName).matches();

		if (isEmpty == true || existService == true || isNumNumeric == false) {
			return false;
		} else {
			return true;
		}
	}

}
