package jp.co.ase.izpack.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.DataValidator;

public class WindowsServiceNameAndPortRepetitionValidator implements DataValidator {

	public boolean getDefaultAnswer() {
		return true;
	}

	/**
	 * エラーメッセージを返却する。
	 */
	public String getErrorMessageId() {
		return "今までに入力したサービス名同士またはポート番号同士が重複しています。重複しないようポート番号を変更してください。";
	}

	/**
	 * ここにくることはないが、とりあえずエラーメッセージと同じにしておく。
	 */
	public String getWarningMessageId() {
		return "今までに入力したサービス名同士またはポート番号同士が重複しています。重複しないようポート番号を変更してください。";
	}

	/**
	 * validate処理を行う。
	 */
	public Status validateData(AutomatedInstallData idata) {
		boolean wsResult = isNoRepetitionWindowsServiceName(idata);
		boolean portResult = isNoRepetitionPort(idata);
		if (wsResult == true && portResult == true) {
			return Status.OK;
		} else {
			return Status.ERROR;
		}
	}

	/**
	 *
	 * @param idata
	 * @return
	 */
	private boolean isNoRepetitionWindowsServiceName(AutomatedInstallData idata) {
		List<String> list = new ArrayList<String>();
		// getVariableで取得するポート番号は必ず値が設定されているので空文字チェックは行わない
		String apache_name = idata.getVariable("apache_name");
		String redmine_name = idata.getVariable("redmine_name");
		String hudson_name = idata.getVariable("hudson_name");
		list.add(apache_name);
		list.add(redmine_name);
		list.add(hudson_name);
		String ldap_setting = idata.getVariable("ldap_setting");
		if (ldap_setting.equals("0") || ldap_setting.equals("false")) {
			String opends_name = idata.getVariable("opends_name");
			list.add(opends_name);
		}

		boolean result = isNoRepetition(list);
		return result;
	}

	/**
	 *
	 * @param idata
	 * @return
	 */
	private boolean isNoRepetitionPort(AutomatedInstallData idata) {
		List<String> list = new ArrayList<String>();
		// getVariableで取得するポート番号は必ず値が設定されているので空文字チェックは行わない
		String apache_port = idata.getVariable("apache_port");
		String redmine_port = idata.getVariable("redmine_port");
		String hudson_port = idata.getVariable("hudson_port");
		list.add(apache_port);
		list.add(redmine_port);
		list.add(hudson_port);
		String ldap_setting = idata.getVariable("ldap_setting");
		if (ldap_setting.equals("0") || ldap_setting.equals("false")) {
			// OpenDSを使う場合
			String opends_port = idata.getVariable("opends_port");
			String opends_admin_port = idata.getVariable("opends_admin_port");
			list.add(opends_port);
			list.add(opends_admin_port);
		}

		boolean result = isNoRepetition(list);
		return result;
	}

	/**
	 * list内に重複がないかチェックする。重複がなければtrue、重複があった場合はfalseを返す。
	 *
	 * @param list
	 * @return
	 */
	public boolean isNoRepetition(List<String> list) {
		// listで重複があったものは削除される
		HashSet<String> set = new HashSet<String>(list);
		int setSize = set.size();
		int listSize = list.size();
		if (setSize != listSize) {
			return false;
		}
		return true;
	}
}
